/*****************************************************************************
*   "Gif-Lib" - Yet another gif library.				     *
*									     *
* Written by:  Gershon Elber			IBM PC Ver 0.1,	Jul. 1989    *
******************************************************************************
* Program to convert GIF file RLE format (utah raster toolkit).		     *
* Options:								     *
* -a : add alpha channel with full coverage.				     *
* -h : on line help.							     *
******************************************************************************
* History:								     *
* 5 Jan 90 - Version 1.0 by Gershon Elber.				     *
*****************************************************************************/

#ifdef __MSDOS__
#include <graphics.h>
#include <stdlib.h>
#include <alloc.h>
#include <io.h>
#include <dos.h>
#include <bios.h>
#endif /* __MSDOS__ */

#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include <fcntl.h>
#include "gif_lib.h"
#include "getarg.h"

#include "svfb_global.h"		   /* The rle tool kit header files */

#define PROGRAM_NAME	"Gif2Rle"
#define VERSION		" Version 1.0, "

#ifdef __MSDOS__
extern unsigned int
    _stklen = 16384;			      /* Increase default stack size */
#endif /* __MSDOS__ */

#ifdef SYSV
static char *VersionStr =
        "Gif library module,\t\tGershon Elber\n\
	(C) Copyright 1989 Gershon Elber, Non commercial use only.\n";
static char
    *CtrlStr = "Gif2Rle a%- h%- GifFile!*s";
#else
static char
    *VersionStr =
	PROGRAM_NAME
	"	IBMPC "
	VERSION
	"	Gershon Elber,	"
	__DATE__ ",   " __TIME__ "\n"
	"(C) Copyright 1989 Gershon Elber, Non commercial use only.\n";
static char
    *CtrlStr =
	PROGRAM_NAME
	" a%- h%- GifFile!*s";
#endif /* SYSV */

static char
    *ProgramName;
/* Make some variables global, so we could access them faster: */
static int
    ImageNum = 0,
    BackGround = 0,
    AlphaFlag = FALSE,
    HelpFlag = FALSE,
    ColorMapSize = 0,
    InterlacedOffset[] = { 0, 4, 2, 1 }, /* The way Interlaced image should. */
    InterlacedJumps[] = { 8, 8, 4, 2 };    /* be read - offsets and jumps... */
static GifColorType
    *ColorMap;

static void DumpScreen2Rle(RowType *ScreenBuffer,
					int ScreenWidth, int ScreenHeight);

/******************************************************************************
* Interpret the command line and scan the given GIF file.		      *
******************************************************************************/
void main(int argc, char **argv)
{
    int	i, j, Error, NumFiles, Size, Row, Col, Width, Height, ExtCode, Count;
    GifRecordType RecordType;
    ByteType *Extension;
    char **FileName = NULL;
    RowType *ScreenBuffer;
    GifFileType *GifFile;

    if (strlen(ProgramName = argv[0]) == 0)		    /* DOS 3.x only! */
	ProgramName = PROGRAM_NAME;	  /* Do something reasonable for 2.x */

    if ((Error = GAGetArgs(argc, argv, CtrlStr,	&AlphaFlag, &HelpFlag,
		&NumFiles, &FileName)) != FALSE ||
		(NumFiles > 1 && !HelpFlag)) {
	if (Error) GAPrintErrMsg(Error);
	else
	if (NumFiles > 1)
	    MESSAGE("Error in command line parsing - one GIF file please\n");
	GAPrintHowTo(CtrlStr);
	exit(1);
    }

    if (HelpFlag) {
	fprintf(stderr, VersionStr);
	GAPrintHowTo(CtrlStr);
	exit(0);
    }
    
    if (NumFiles == 1) {
	if ((GifFile = DGifOpenFileName(*FileName)) == NULL) {
	    PrintGifError();
	    exit(-1);
	}
    }
    else {
	/* Use the stdin instead: */

#ifdef __MSDOS__
	setmode(0, O_BINARY);
#endif /* __MSDOS__ */
	if ((GifFile = DGifOpenFileHandle(0)) == NULL) {
	    PrintGifError();
	    exit(-1);
	}
    }

    /* Allocate the screen as vector of column of rows. We cannt allocate    */
    /* the all screen at once, as this broken minded CPU can allocate up to  */
    /* 64k at a time and our image can be bigger than that:		     */
    /* Note this screen is device independent - its the screen as defined by */
    /* the GIF file parameters itself.					     */
    if ((ScreenBuffer = (RowType *)
	malloc(GifFile -> SHeight * sizeof(RowType *))) == NULL)
	    EXIT("Failed to allocate memory required, aborted");

    Size = GifFile -> SWidth * sizeof(PixelType);/* Size in bytes of one row */
    if ((ScreenBuffer[0] = (RowType) malloc(Size)) == NULL)     /* First row */
	EXIT("Failed to allocate memory required, aborted");

    for (i=0; i<GifFile -> SWidth; i++)	  /* And set its color to BackGround */
	ScreenBuffer[0][i] = GifFile -> SBackGroundColor;
    for (i=1; i<GifFile -> SHeight; i++) {
	/* Allocate the other rows, and set their color to background too: */
	if ((ScreenBuffer[i] = (RowType) malloc(Size)) == NULL)
	    EXIT("Failed to allocate memory required, aborted\n");

	memcpy(ScreenBuffer[i], ScreenBuffer[0], Size);
    }

    /* Scan the content of the GIF file and load the image(s) in: */
    do {
	if (DGifGetRecordType(GifFile, &RecordType) == ERROR) {
	    PrintGifError();
	    exit(-1);
	}
	switch (RecordType) {
	    case IMAGE_DESC_RECORD_TYPE:
		if (DGifGetImageDesc(GifFile) == ERROR) {
		    PrintGifError();
		    exit(-1);
		}
		Row = GifFile -> ITop;  /* Image Position relative to Screen */
		Col = GifFile -> ILeft;
		Width = GifFile -> IWidth;
		Height = GifFile -> IHeight;
		fprintf(stderr, "\n%s: Image %d at (%d, %d) [%dx%d]:     ",
		    ProgramName, ++ImageNum, Col, Row, Width, Height);
		if (GifFile -> ILeft + GifFile -> IWidth > GifFile -> SWidth ||
		   GifFile -> ITop + GifFile -> IHeight > GifFile -> SHeight) {
		    fprintf(stderr, "Image %d is not confined to screen dimension, aborted\n");
		    exit(-2);
		}
		if (GifFile -> IInterlace) {
		    /* Need to perform 4 passes on the images: */
		    for (Count=i=0; i<4; i++)
			for (j=Row + InterlacedOffset[i]; j<Row + Height;
						 j += InterlacedJumps[i]) {
			    fprintf(stderr, "\b\b\b\b%-4d", Count++);
			    if (DGifGetLine(GifFile, &ScreenBuffer[j][Col],
				Width) == ERROR) {
				PrintGifError();
				exit(-1);
			    }
			}
		}
		else {
		    for (i=0; i<Height; i++) {
			fprintf(stderr, "\b\b\b\b%-4d", i);
			if (DGifGetLine(GifFile, &ScreenBuffer[Row++][Col],
				Width) == ERROR) {
			    PrintGifError();
			    exit(-1);
			}
		    }
		}
		break;
	    case EXTENSION_RECORD_TYPE:
		/* Skip any extension blocks in file: */
		if (DGifGetExtension(GifFile, &ExtCode, &Extension) == ERROR) {
		    PrintGifError();
		    exit(-1);
		}
		while (Extension != NULL) {
		    if (DGifGetExtensionNext(GifFile, &Extension) == ERROR) {
			PrintGifError();
			exit(-1);
		    }
		}
		break;
	    case TERMINATE_RECORD_TYPE:
		break;
	    default:		     /* Should be traps by DGifGetRecordType */
		break;
	}
    }
    while (RecordType != TERMINATE_RECORD_TYPE);

    /* Lets display it - set the global variables required and do it: */
    BackGround = GifFile -> SBackGroundColor;
    ColorMap = (GifFile -> IColorMap ? GifFile -> IColorMap :
				       GifFile -> SColorMap);
    ColorMapSize = 1 << (GifFile -> IColorMap ? GifFile -> IBitsPerPixel :
				                GifFile -> SBitsPerPixel);
    DumpScreen2Rle(ScreenBuffer, GifFile -> SWidth, GifFile -> SHeight);

    if (DGifCloseFile(GifFile) == ERROR) {
	PrintGifError();
	exit(-1);
    }
}

/******************************************************************************
* The real dumping routine.						      *
******************************************************************************/
static void DumpScreen2Rle(RowType *ScreenBuffer,
					int ScreenWidth, int ScreenHeight)
{
    int i, j;
    char Comment[80];
    rle_pixel *rows[4];
    RowType GifRow;
    static GifColorType
	*ColorMapEntry;

    if (AlphaFlag) SV_SET_BIT(sv_globals, SV_ALPHA);
    sv_globals.sv_alpha = AlphaFlag != 0;
    sv_globals.svfb_fd = stdout;
    sv_globals.sv_xmin = 0;
    sv_globals.sv_ymin = 0;
    sv_globals.sv_xmax = ScreenWidth - 1;
    sv_globals.sv_ymax = ScreenHeight - 1;
    sprintf(Comment, "origin=GIF format, %d colors", ColorMapSize);
    rle_putcom(Comment, &sv_globals);
    sv_setup(RUN_DISPATCH, &sv_globals);

    for (i=0; i<4; i++)
	if ((rows[i] = (rle_pixel *) malloc(sizeof(rle_pixel) * ScreenWidth)) ==
		    							NULL)
	    EXIT("Failed to allocated memory required, aborted");

    if (AlphaFlag) {
	/* Initial the alpha channel to full coverage: */
	for (i=0; i<ScreenWidth; i++) rows[0][i] = 255;
    }

    for (i=0; i<ScreenHeight; i++) {
	/* Flip the image vertically as rle files start at the bollom... */
	GifRow = ScreenBuffer[ScreenHeight - i - 1];
	fprintf(stderr, "\b\b\b\b%-4d", ScreenHeight - i);
	for (j=0; j<ScreenWidth; j++) {
	    ColorMapEntry = &ColorMap[GifRow[j]];
	    rows[1][j] = ColorMapEntry -> Red;
	    rows[2][j] = ColorMapEntry -> Green;
	    rows[3][j] = ColorMapEntry -> Blue;
	}
	sv_putrow( &rows[1], ScreenWidth, &sv_globals );
    }

    sv_puteof( &sv_globals );
}
