#include <alloc.h>
#include "hobbes.h"


void CreateAlignedMaskedImage(MaskedImage *ImageToSet, char *Image,
		int ImageWidth,	int ImageHeight, char *Mask) {
	VRAM_PTR DispMemStart = Bitmap_Offset;

   int Align, ScanLine, BitNum, Size, TempImageWidth;
   unsigned char MaskTemp;
   unsigned int DispMemOffset = DispMemStart;
   AlignedMaskedImage *WorkingAMImage;
   char *NewMaskPtr, *OldMaskPtr;
   /* Generate each of the four alignments in turn */
   for (Align = 0; Align < 4; Align++) {
	  /* Allocate space for the AlignedMaskedImage struct for this
		 alignment */
	  if ((WorkingAMImage = ImageToSet->Alignments[Align] = (AlignedMaskedImage*)
			malloc(sizeof(AlignedMaskedImage))) == NULL)
		 return;
	  WorkingAMImage->ImageWidth =
			(ImageWidth + Align + 3) / 4; /* width in 4-pixel sets */
	  WorkingAMImage->ImagePtr = DispMemOffset; /* image dest */
	  /* Download this alignment of the image */
	  CopySystemToScreen(0, 0, ImageWidth, ImageHeight, Align, 0,
			Image, DispMemOffset, ImageWidth,
			WorkingAMImage->ImageWidth * 4);
	  /* Calculate the number of bytes needed to store the mask in
		 nibble (Map Mask-ready) form, then allocate that space */
	  Size = WorkingAMImage->ImageWidth * ImageHeight;
	  if ((WorkingAMImage->MaskPtr = (char*) malloc(Size)) == NULL)
		 return;
	  /* Generate this nibble oriented (Map Mask-ready) alignment of
		 the mask, one scan line at a time */
	  OldMaskPtr = Mask;
	  NewMaskPtr = WorkingAMImage->MaskPtr;
	  for (ScanLine = 0; ScanLine < ImageHeight; ScanLine++) {
		 BitNum = Align;
		 MaskTemp = 0;
		 TempImageWidth = ImageWidth;
		 do {
			/* Set the mask bit for next pixel according to its alignment */
			MaskTemp |= (*OldMaskPtr++ != 0) << BitNum;
			if (++BitNum > 3) {
			   *NewMaskPtr++ = MaskTemp;
			   MaskTemp = BitNum = 0;
			}
		 } while (--TempImageWidth);
		 /* Set any partial final mask on this scan line */
		 if (BitNum != 0) *NewMaskPtr++ = MaskTemp;
	  }
	  DispMemOffset += Size; /* mark off the space we just used */
   }
//   return DispMemOffset - DispMemStart;
   Bitmap_Offset += (DispMemOffset - DispMemStart);
}

void CopyScreenToScreenMasked(int SourceStartX, int SourceStartY,
	int SourceEndX, int SourceEndY,	int DestStartX, int DestStartY,
	MaskedImage *Source, VRAM_PTR DestPageBase, int DestWidth) {

	int psi, imagewidth;
	VRAM_PTR imageptr;
	char *maskptr;


	psi = DestStartX & 3;
	imagewidth = 	(Source->Alignments[psi])->ImageWidth;
	imageptr = 		(Source->Alignments[psi])->ImagePtr;
	maskptr = 		(Source->Alignments[psi])->MaskPtr;

	CopyScreenToScreenMaskedX(SourceStartX, SourceStartY,
				SourceEndX, SourceEndY,
				DestStartX, DestStartY,
				imagewidth, imageptr, maskptr);
}


