#include "hobbes.h"


void CirclePoints(int, int, int, int, COLOR);
void CirclePointsClip(int, int, int, int, COLOR);
void CirclePointsPattern(int, int, int, int, PATTERN);
void CirclePointsPatternClip(int, int, int, int, PATTERN);
void CirclePointsFillPattern(int, int, int, int, PATTERN);
void CirclePointsFillPatternClip(int, int, int, int, PATTERN);

void CirclePoints(int x, int y, int cx, int cy, COLOR c) {
	Pixel(cx+x,cy+y,c);
	Pixel(cx+y,cy+x,c);
	Pixel(cx+y,cy+-x,c);
	Pixel(cx+x,cy+-y,c);
	Pixel(cx+-x,cy+-y,c);
	Pixel(cx+-y,cy+-x,c);
	Pixel(cx+-y,cy+x,c);
	Pixel(cx+-x,cy+y,c);
}

void CirclePointsClip(int x, int y, int cx, int cy, COLOR c) {
	PixelClip(cx+x,cy+y,c);
	PixelClip(cx+y,cy+x,c);
	PixelClip(cx+y,cy+-x,c);
	PixelClip(cx+x,cy+-y,c);
	PixelClip(cx+-x,cy+-y,c);
	PixelClip(cx+-y,cy+-x,c);
	PixelClip(cx+-y,cy+x,c);
	PixelClip(cx+-x,cy+y,c);
}

void CirclePointsPattern(int x, int y, int cx, int cy, PATTERN p) {
	int cxx=cx+x;
	int cxy=cx+y;
	int _cxx=cx-x;
	int _cxy=cx-y;
	int cyy=cy+y;
	int cyx=cy+x;
	int _cyy=cy-y;
	int _cyx=cy-x;

	PixelPattern(cxx,cyy,p);
	PixelPattern(cxy,cyx,p);
	PixelPattern(cxy,_cyx,p);
	PixelPattern(cxx,_cyy,p);
	PixelPattern(_cxx,_cyy,p);
	PixelPattern(_cxy,_cyx,p);
	PixelPattern(_cxy,cyx,p);
	PixelPattern(_cxx,cyy,p);
}

void CirclePointsPatternClip(int x, int y, int cx, int cy, PATTERN p) {
	int cxx=cx+x;
	int cxy=cx+y;
	int _cxx=cx-x;
	int _cxy=cx-y;
	int cyy=cy+y;
	int cyx=cy+x;
	int _cyy=cy-y;
	int _cyx=cy-x;

	PixelPatternClip(cxx,cyy,p);
	PixelPatternClip(cxy,cyx,p);
	PixelPatternClip(cxy,_cyx,p);
	PixelPatternClip(cxx,_cyy,p);
	PixelPatternClip(_cxx,_cyy,p);
	PixelPatternClip(_cxy,_cyx,p);
	PixelPatternClip(_cxy,cyx,p);
	PixelPatternClip(_cxx,cyy,p);
}

void CirclePointsFillPattern(int x, int y, int cx, int cy, PATTERN p) {
	HLinePattern(cx-x,cx+x,cy+y,p);
	HLinePattern(cx-y,cx+y,cy+x,p);
	HLinePattern(cx-y,cx+y,cy-x,p);
	HLinePattern(cx-x,cx+x,cy-y,p);
}

void CirclePointsFillPatternClip(int x, int y, int cx, int cy, PATTERN p) {
	HLinePatternClip(cx-x,cx+x,cy+y,p);
	HLinePatternClip(cx-y,cx+y,cy+x,p);
	HLinePatternClip(cx-y,cx+y,cy-x,p);
	HLinePatternClip(cx-x,cx+x,cy-y,p);
}



void Circle(int centerx, int centery, int radius, COLOR c) {

	int x, y,
		d, deltaE, deltaSE;

	x = 0;
	y = radius;
	d = 1-radius;
	deltaE = 3;
	deltaSE = -2*radius + 5;
	CirclePoints(x, y, centerx, centery, c);

	while (y > x) {
		if (d<0) {
			d += deltaE;
			deltaE += 2;
			deltaSE += 2;
			x++;
			}
		  else {
			d += deltaSE;
			deltaE += 2;
			deltaSE += 4;
			x++;
			y--;
		}
		CirclePoints(x, y, centerx, centery, c);
	}
}


void CircleClip(int centerx, int centery, int radius, COLOR c) {
	int x, y,
		d, deltaE, deltaSE;

	x = 0;
	y = radius;
	d = 1-radius;
	deltaE = 3;
	deltaSE = -2*radius + 5;
	CirclePointsClip(x, y, centerx, centery, c);

	while (y > x) {
		if (d<0) {
			d += deltaE;
			deltaE += 2;
			deltaSE += 2;
			x++;
			}
		  else {
			d += deltaSE;
			deltaE += 2;
			deltaSE += 4;
			x++;
			y--;
		}
		CirclePointsClip(x, y, centerx, centery, c);
	}
}



void CirclePattern(int centerx, int centery, int radius, PATTERN p) {

	int x, y,
		d, deltaE, deltaSE;

	x = 0;
	y = radius;
	d = 1-radius;
	deltaE = 3;
	deltaSE = -2*radius + 5;
	CirclePointsPattern(x, y, centerx, centery, p);

	while (y > x) {
		if (d<0) {
			d += deltaE;
			deltaE += 2;
			deltaSE += 2;
			x++;
			}
		  else {
			d += deltaSE;
			deltaE += 2;
			deltaSE += 4;
			x++;
			y--;
		}
		CirclePointsPattern(x, y, centerx, centery, p);
	}
}

void CirclePatternClip(int centerx, int centery, int radius, PATTERN p) {
	int x, y,
		d, deltaE, deltaSE;

	x = 0;
	y = radius;
	d = 1-radius;
	deltaE = 3;
	deltaSE = -2*radius + 5;
	CirclePointsPatternClip(x, y, centerx, centery, p);

	while (y > x) {
		if (d<0) {
			d += deltaE;
			deltaE += 2;
			deltaSE += 2;
			x++;
			}
		  else {
			d += deltaSE;
			deltaE += 2;
			deltaSE += 4;
			x++;
			y--;
		}
		CirclePointsPatternClip(x, y, centerx, centery, p);
	}

}

void CircleFillPattern(int centerx, int centery, int radius, PATTERN p) {
	int x, y,
		d, deltaE, deltaSE;

	x = 0;
	y = radius;
	d = 1-radius;
	deltaE = 3;
	deltaSE = -2*radius + 5;
	CirclePointsFillPattern(x, y, centerx, centery, p);

	while (y > x) {
		if (d<0) {
			d += deltaE;
			deltaE += 2;
			deltaSE += 2;
			x++;
			}
		  else {
			d += deltaSE;
			deltaE += 2;
			deltaSE += 4;
			x++;
			y--;
		}
		CirclePointsFillPattern(x, y, centerx, centery, p);
	}

}

void CircleFillPatternClip(int centerx, int centery, int radius, PATTERN p) {
	int x, y,
		d, deltaE, deltaSE;

	x = 0;
	y = radius;
	d = 1-radius;
	deltaE = 3;
	deltaSE = -2*radius + 5;
	CirclePointsFillPatternClip(x, y, centerx, centery, p);

	while (y > x) {
		if (d<0) {
			d += deltaE;
			deltaE += 2;
			deltaSE += 2;
			x++;
			}
		  else {
			d += deltaSE;
			deltaE += 2;
			deltaSE += 4;
			x++;
			y--;
		}
		CirclePointsFillPatternClip(x, y, centerx, centery, p);
	}

}


