#include "hobbes.h"

void Plot4(int x, int y, int a, int b, COLOR c)
{
	int x1,x2, y1,y2;
	x1 = x-a;
	x2 = x+a;
	y1 = y-b;
	y2 = y+b;

	Pixel(x1,y1, c);
	if (x1!=x2)
		Pixel(x2,y1,c);
	if (y1!=y2) {
		Pixel(x1,y2,c);
		if (x1!=x2)
			Pixel(x2,y2,c);
	}
}

void Plot4Clip(int x, int y, int a, int b, COLOR c)
{
	int x1,x2, y1,y2;
	x1 = x-a;
	x2 = x+a;
	y1 = y-b;
	y2 = y+b;

	PixelClip(x1,y1, c);
	if (x1!=x2)
		PixelClip(x2,y1,c);
	if (y1!=y2) {
		PixelClip(x1,y2,c);
		if (x1!=x2)
			PixelClip(x2,y2,c);
	}
}


void Plot4Fill(int x, int y, int a, int b, COLOR c)
{
	int x1,x2, y1,y2;
	x1 = x-a;
	x2 = x+a;
	y1 = y-b;
	y2 = y+b;

	HLine(x1,x2,y1,c);
	if (y1!=y2)
		HLine(x1,x2,y2,c);
}

void Plot4FillClip(int x, int y, int a, int b, COLOR c)
{
	int x1,x2, y1,y2;
	x1 = x-a;
	x2 = x+a;
	y1 = y-b;
	y2 = y+b;

	HLineClip(x1,x2,y1,c);
	if (y1!=y2)
		HLineClip(x1,x2,y2,c);
}


void Plot4Pattern(int x, int y, int a, int b, PATTERN p)
{
	int x1,x2, y1,y2;
	x1 = x-a;
	x2 = x+a;
	y1 = y-b;
	y2 = y+b;

	PixelPattern(x1,y1,p);
	if (x1!=x2)
		PixelPattern(x2,y1,p);
	if (y1!=y2) {
		PixelPattern(x1,y2,p);
		if (x1!=x2)
			PixelPattern(x2,y2,p);
	}
}

void Plot4PatternClip(int x, int y, int a, int b, PATTERN p)
{
	int x1,x2, y1,y2;
	x1 = x-a;
	x2 = x+a;
	y1 = y-b;
	y2 = y+b;
	PixelPatternClip(x1,y1,p);
	if (x1!=x2)
		PixelPatternClip(x2,y1,p);
	if (y1!=y2) {
		PixelPatternClip(x1,y2,p);
		if (x1!=x2)
			PixelPatternClip(x2,y2,p);
	}

}

void Plot4FillPattern(int x, int y, int a, int b, PATTERN p)
{
	int x1,x2, y1,y2;
	x1 = x-a;
	x2 = x+a;
	y1 = y-b;
	y2 = y+b;

	HLinePattern(x1,x2,y1,p);
	if (y1!=y2)
		HLinePattern(x1,x2,y2,p);
}

void Plot4FillPatternClip(int x, int y, int a, int b, PATTERN p)
{
	int x1,x2, y1,y2;
	x1 = x-a;
	x2 = x+a;
	y1 = y-b;
	y2 = y+b;

	HLinePatternClip(x1,x2,y1,p);
	if (y1!=y2)
		HLinePatternClip(x1,x2,y2,p);
}


/*********************************************************************
 * Draw ellipse with center at x,y, horiz. radius a and vert. radius b
 * The algorithm is from "An Efficient Ellipse-Drawing Algorithm" by
 * Jerry R. Van Aken, IEEE CG&A, September 1984, pp. 24-35,
 * specifically, Figure 10 on page 32.
 *
 * FOR SOME REASON THIS FUNCTION FAILS IF a OR b IS LARGER THAN 255
 ********************************************************************/

void Ellipse(int centerx, int centery, int a, int b, COLOR c)
{
	register long   d1, d2;
	register int    x, y;
	register long   t1, t2, t3, t4, t5, t6, t7, t8, t9;

	/* intermediate terms to speed up loop */
	t1 = a * a; t2 = t1 << 1;   t3 = t2 << 1;
	t4 = b * b; t5 = t4 << 1;   t6 = t5 << 1;
	t7 = a * t5;    t8 = t7 << 1;   t9 = 0L;

	d1 = t2 - t7 + (t4 >> 1);   /* error terms */
	d2 = (t1 >> 1) - t8 + t5;

	x = a;
	y = 0;

	while (d2 < 0) {        /* region 1 of ellipse */
		Plot4(centerx, centery, x, y, c);
		y++;        /* always move up here */
		t9 += t3;
		if (d1 < 0) {       /* move straight up */
			d1 += t9 + t2;
			d2 += t9;
		} else {        /* move up and left */
			x--;
			t8 -= t6;
			d1 += t9 + t2 - t8;
			d2 += t9 + t5 - t8;
		}
	}

	do {                /* region 2 of ellipse */
		Plot4(centerx, centery, x, y, c);
		x--;        /* always move left here */
		t8 -= t6;
		if (d2 < 0) {   /* move up and left */
			y++;
			t9 += t3;
			d2 += t9 + t5 - t8;
		} else      /* move straight left */
			d2 += t5 - t8;
	} while (x >= 0);
}

void EllipseClip(int centerx, int centery, int a, int b, COLOR c)
{
	register long   d1, d2;
	register int    x, y;
	register long   t1, t2, t3, t4, t5, t6, t7, t8, t9;

	/* intermediate terms to speed up loop */
	t1 = a * a; t2 = t1 << 1;   t3 = t2 << 1;
	t4 = b * b; t5 = t4 << 1;   t6 = t5 << 1;
	t7 = a * t5;    t8 = t7 << 1;   t9 = 0L;

	d1 = t2 - t7 + (t4 >> 1);   /* error terms */
	d2 = (t1 >> 1) - t8 + t5;

	x = a;
	y = 0;

	while (d2 < 0) {        /* region 1 of ellipse */
		Plot4Clip(centerx, centery, x, y, c);
		y++;        /* always move up here */
		t9 += t3;
		if (d1 < 0) {       /* move straight up */
			d1 += t9 + t2;
			d2 += t9;
		} else {        /* move up and left */
			x--;
			t8 -= t6;
			d1 += t9 + t2 - t8;
			d2 += t9 + t5 - t8;
		}
	}

	do {                /* region 2 of ellipse */
		Plot4Clip(centerx, centery, x, y, c);
		x--;        /* always move left here */
		t8 -= t6;
		if (d2 < 0) {   /* move up and left */
			y++;
			t9 += t3;
			d2 += t9 + t5 - t8;
		} else      /* move straight left */
			d2 += t5 - t8;
	} while (x >= 0);
}



void EllipseFill(int centerx, int centery, int a, int b, COLOR c)
{
	register long   d1, d2;
	register int    x, y;
	register long   t1, t2, t3, t4, t5, t6, t7, t8, t9;

	/* intermediate terms to speed up loop */
	t1 = a * a; t2 = t1 << 1;   t3 = t2 << 1;
	t4 = b * b; t5 = t4 << 1;   t6 = t5 << 1;
	t7 = a * t5;    t8 = t7 << 1;   t9 = 0L;

	d1 = t2 - t7 + (t4 >> 1);   /* error terms */
	d2 = (t1 >> 1) - t8 + t5;

	x = a;
	y = 0;

	while (d2 < 0) {        /* region 1 of ellipse */
		Plot4Fill(centerx, centery, x, y, c);
		y++;        /* always move up here */
		t9 += t3;
		if (d1 < 0) {       /* move straight up */
			d1 += t9 + t2;
			d2 += t9;
		} else {        /* move up and left */
			x--;
			t8 -= t6;
			d1 += t9 + t2 - t8;
			d2 += t9 + t5 - t8;
		}
	}

	do {                /* region 2 of ellipse */
		x--;        /* always move left here */
		t8 -= t6;
		if (d2 < 0) {   /* move up and left */
			Plot4Fill(centerx, centery, x, y, c);
			y++;
			t9 += t3;
			d2 += t9 + t5 - t8;
		} else      /* move straight left */
			d2 += t5 - t8;
	} while (x >= 0);
}

void EllipseFillClip(int centerx, int centery, int a, int b, COLOR c)
{
	register long   d1, d2;
	register int    x, y;
	register long   t1, t2, t3, t4, t5, t6, t7, t8, t9;

	/* intermediate terms to speed up loop */
	t1 = a * a; t2 = t1 << 1;   t3 = t2 << 1;
	t4 = b * b; t5 = t4 << 1;   t6 = t5 << 1;
	t7 = a * t5;    t8 = t7 << 1;   t9 = 0L;

	d1 = t2 - t7 + (t4 >> 1);   /* error terms */
	d2 = (t1 >> 1) - t8 + t5;

	x = a;
	y = 0;

	while (d2 < 0) {        /* region 1 of ellipse */
		Plot4FillClip(centerx, centery, x, y, c);
		y++;        /* always move up here */
		t9 += t3;
		if (d1 < 0) {       /* move straight up */
			d1 += t9 + t2;
			d2 += t9;
		} else {        /* move up and left */
			x--;
			t8 -= t6;
			d1 += t9 + t2 - t8;
			d2 += t9 + t5 - t8;
		}
	}

	do {                /* region 2 of ellipse */
		x--;        /* always move left here */
		t8 -= t6;
		if (d2 < 0) {   /* move up and left */
			Plot4FillClip(centerx, centery, x, y, c);
			y++;
			t9 += t3;
			d2 += t9 + t5 - t8;
		} else      /* move straight left */
			d2 += t5 - t8;
	} while (x >= 0);
}


void EllipsePattern(int centerx, int centery, int a, int b, PATTERN p)
{
	register long   d1, d2;
	register int    x, y;
	register long   t1, t2, t3, t4, t5, t6, t7, t8, t9;

	/* intermediate terms to speed up loop */
	t1 = a * a; t2 = t1 << 1;   t3 = t2 << 1;
	t4 = b * b; t5 = t4 << 1;   t6 = t5 << 1;
	t7 = a * t5;    t8 = t7 << 1;   t9 = 0L;

	d1 = t2 - t7 + (t4 >> 1);   /* error terms */
	d2 = (t1 >> 1) - t8 + t5;

	x = a;
	y = 0;

	while (d2 < 0) {        /* region 1 of ellipse */
		Plot4Pattern(centerx, centery, x, y, p);
		y++;        /* always move up here */
		t9 += t3;
		if (d1 < 0) {       /* move straight up */
			d1 += t9 + t2;
			d2 += t9;
		} else {        /* move up and left */
			x--;
			t8 -= t6;
			d1 += t9 + t2 - t8;
			d2 += t9 + t5 - t8;
		}
	}

	do {                /* region 2 of ellipse */
		Plot4Pattern(centerx, centery, x, y, p);
		x--;        /* always move left here */
		t8 -= t6;
		if (d2 < 0) {   /* move up and left */
			y++;
			t9 += t3;
			d2 += t9 + t5 - t8;
		} else      /* move straight left */
			d2 += t5 - t8;
	} while (x >= 0);
}


void EllipsePatternClip(int centerx, int centery, int a, int b, PATTERN p)
{
	register long   d1, d2;
	register int    x, y;
	register long   t1, t2, t3, t4, t5, t6, t7, t8, t9;

	/* intermediate terms to speed up loop */
	t1 = a * a; t2 = t1 << 1;   t3 = t2 << 1;
	t4 = b * b; t5 = t4 << 1;   t6 = t5 << 1;
	t7 = a * t5;    t8 = t7 << 1;   t9 = 0L;

	d1 = t2 - t7 + (t4 >> 1);   /* error terms */
	d2 = (t1 >> 1) - t8 + t5;

	x = a;
	y = 0;

	while (d2 < 0) {        /* region 1 of ellipse */
		Plot4PatternClip(centerx, centery, x, y, p);
		y++;        /* always move up here */
		t9 += t3;
		if (d1 < 0) {       /* move straight up */
			d1 += t9 + t2;
			d2 += t9;
		} else {        /* move up and left */
			x--;
			t8 -= t6;
			d1 += t9 + t2 - t8;
			d2 += t9 + t5 - t8;
		}
	}

	do {                /* region 2 of ellipse */
		Plot4PatternClip(centerx, centery, x, y, p);
		x--;        /* always move left here */
		t8 -= t6;
		if (d2 < 0) {   /* move up and left */
			y++;
			t9 += t3;
			d2 += t9 + t5 - t8;
		} else      /* move straight left */
			d2 += t5 - t8;
	} while (x >= 0);
}




void EllipseFillPattern(int centerx, int centery, int a, int b, PATTERN p)
{
	register long   d1, d2;
	register int    x, y;
	register long   t1, t2, t3, t4, t5, t6, t7, t8, t9;

	/* intermediate terms to speed up loop */
	t1 = a * a; t2 = t1 << 1;   t3 = t2 << 1;
	t4 = b * b; t5 = t4 << 1;   t6 = t5 << 1;
	t7 = a * t5;    t8 = t7 << 1;   t9 = 0L;

	d1 = t2 - t7 + (t4 >> 1);   /* error terms */
	d2 = (t1 >> 1) - t8 + t5;

	x = a;
	y = 0;

	while (d2 < 0) {        /* region 1 of ellipse */
		Plot4FillPattern(centerx, centery, x, y, p);
		y++;        /* always move up here */
		t9 += t3;
		if (d1 < 0) {       /* move straight up */
			d1 += t9 + t2;
			d2 += t9;
		} else {        /* move up and left */
			x--;
			t8 -= t6;
			d1 += t9 + t2 - t8;
			d2 += t9 + t5 - t8;
		}
	}

	do {                /* region 2 of ellipse */
		Plot4FillPattern(centerx, centery, x, y, p);
		x--;        /* always move left here */
		t8 -= t6;
		if (d2 < 0) {   /* move up and left */
			y++;
			t9 += t3;
			d2 += t9 + t5 - t8;
		} else      /* move straight left */
			d2 += t5 - t8;
	} while (x >= 0);
}


void EllipseFillPatternClip(int centerx, int centery, int a, int b, PATTERN p)
{
	register long   d1, d2;
	register int    x, y;
	register long   t1, t2, t3, t4, t5, t6, t7, t8, t9;

	/* intermediate terms to speed up loop */
	t1 = a * a; t2 = t1 << 1;   t3 = t2 << 1;
	t4 = b * b; t5 = t4 << 1;   t6 = t5 << 1;
	t7 = a * t5;    t8 = t7 << 1;   t9 = 0L;

	d1 = t2 - t7 + (t4 >> 1);   /* error terms */
	d2 = (t1 >> 1) - t8 + t5;

	x = a;
	y = 0;

	while (d2 < 0) {        /* region 1 of ellipse */
		Plot4FillPatternClip(centerx, centery, x, y, p);
		y++;        /* always move up here */
		t9 += t3;
		if (d1 < 0) {       /* move straight up */
			d1 += t9 + t2;
			d2 += t9;
		} else {        /* move up and left */
			x--;
			t8 -= t6;
			d1 += t9 + t2 - t8;
			d2 += t9 + t5 - t8;
		}
	}

	do {                /* region 2 of ellipse */
		Plot4FillPatternClip(centerx, centery, x, y, p);
		x--;        /* always move left here */
		t8 -= t6;
		if (d2 < 0) {   /* move up and left */
			y++;
			t9 += t3;
			d2 += t9 + t5 - t8;
		} else      /* move straight left */
			d2 += t5 - t8;
	} while (x >= 0);
}

