// the ModeX header from HELL

#pragma hdrfile "modex.SYM"
#ifndef HOBBES_H
#define HOBBES_H


#define TRUE 		1
#define FALSE 		0

/* default colors
BLACK          0  
BLUE           1  
GREEN          2  
CYAN           3  
RED            4  
MAGENTA        5  
BROWN          6  
LIGHTGRAY      7  
DARKGRAY       8  
LIGHTBLUE      9  
LIGHTGREEN    10  
LIGHTCYAN     11  
LIGHTRED      12  
LIGHTMAGENTA  13  
YELLOW        14  
WHITE         15  
*/
#define CRTC_INDEX	0x03d4
#define OFFSET		0x13

enum ROP_ENUM { PUT_ROP=0, AND_ROP=8, OR_ROP=16, XOR_ROP=24 };

typedef unsigned char BYTE;
typedef unsigned int  WORD;     /* 16 bits */
typedef unsigned long DWORD;    /* 32 bits */
typedef char 			BOOL;
typedef int 			COLOR;
typedef far char*		PATTERN;
typedef unsigned int  	VRAM_PTR;
typedef enum ROP_ENUM	ROP;
#define PALETTE BYTE[256][3]


extern int RowOffset[];
extern unsigned Background_Offset;
extern unsigned Bitmap_Offset, Pattern_Offset;
extern unsigned ClipLeft, ClipTop, ClipRight, ClipBottom;
extern unsigned ModeX_Segment, Draw_Offset, Display_Offset;
extern unsigned Split_Line, Split_Offset, Page0_Offset, Page1_Offset;
extern unsigned Virtual_Width_Addr, Virtual_Height_Addr;
extern unsigned Virtual_Width_Pix, Virtual_Height_Pix, Virtual_Size;
extern unsigned Background_Offset, Bitmap_Offset, Pattern_Offset;
extern unsigned Double_Buffer, Current_Page;
extern unsigned Physical_Width_Addr, Physical_Height_Addr;
extern unsigned Physical_Width_Pix, Physical_Height_Pix;
extern unsigned MousePage_Offset;

#ifdef __cplusplus
extern "C" {
#endif

void	WaitForRetrace		(void);
void 	SwapPage			(void);
void	FlipPage			(void);
void 	SetClipPort			(int Left, int Top, int Right, int Bottom);
void 	SetVirtualPort		(int MaxX, int MaxY);
void 	ClearClipPort		(void);
void 	ClearVirtualPort	(void);
void 	SetDisplay			(int x, int y);

void	Set320x200Mode		(void);
void 	Set320x240Mode		(void);
void 	Set320x400Mode		(void);
void 	Set360x480Mode		(void);
void 	SetSplit			(unsigned Line);
void 	ShowPage			(VRAM_PTR Offset);
void	RestoreTextMode		(void);

void  	Set1Palette			(int entry, char red, char green, char blue);
void  	Get256Palette		(COLOR palette[256][3]);
void  	Set256Palette		(COLOR palette[256][3]);
void	FadeOut				(int steps, COLOR palette[256][3]);
void	FadeIn				(int steps, COLOR palette[256][3]);

void  	Pixel				(int x, int y, COLOR);
void  	PixelClip			(int x, int y, COLOR);
void 	PixelROP			(int x, int y, COLOR, ROP);
void   	PixelPattern		(int x, int y, PATTERN);
void  	PixelPatternClip	(int x, int y, PATTERN);
COLOR 	PixelSwap			(int x, int y, COLOR);
COLOR 	ReadPixel			(int x, int y);

void 	HLine				(int x0, int x1, int y, COLOR);
void 	HLineClip			(int x0, int x1, int y, COLOR);
void 	HLinePattern		(int x0, int x1, int y, PATTERN);
void 	HLinePatternClip	(int x0, int x1, int y, PATTERN);
void 	VLine				(int x, int y0, int y1, COLOR);
void 	VLineClip			(int x, int y0, int y1, COLOR);
void 	VLinePattern		(int x, int y0, int y1, PATTERN);
void 	VLinePatternClip	(int x, int y0, int y1, PATTERN);
void 	Line				(int x1, int y1, int x2, int y2, COLOR);
void	LineClip			(int x1, int y1, int x2, int y2, COLOR);

void 	Rectangle           	(int x0, int y0, int x1, int y1, COLOR);
void 	RectangleClip       	(int x0, int y0, int x1, int y1, COLOR);
void 	RectangleFill			(int x0, int y0, int x1, int y1, COLOR);
void 	RectangleFillClip		(int x0, int y0, int x1, int y1, COLOR);
void 	RectanglePattern		(int x0, int y0, int x1, int y1, PATTERN);
void 	RectanglePatternClip	(int x0, int y0, int x1, int y1, PATTERN);
void 	RectangleFillPattern	(int x0, int y0, int x1, int y1, PATTERN);
void 	RectangleFillPatternClip(int x0, int y0, int x1, int y1, PATTERN);
void 	RectangleFillAligned	(int x0, int y0, int x1, int y1, COLOR);

void	TriangleFillClip		(int x0, int y0, int x1, int y1, int x2, int y2, COLOR);

void 	Circle              	(int x, int y, int radius, COLOR);
void 	CircleClip          	(int x, int y, int radius, COLOR);
void 	CircleFill				(int x, int y, int radius, COLOR);
void 	CircleFillClip			(int x, int y, int radius, COLOR);
void 	CirclePattern			(int x, int y, int radius, PATTERN);
void 	CirclePatternClip		(int x, int y, int radius, PATTERN);
void 	CircleFillPattern		(int x, int y, int radius, PATTERN);
void 	CircleFillPatternClip	(int x, int y, int radius, PATTERN);

void 	Ellipse					(int x, int y, int a, int b, COLOR);
void 	EllipseClip				(int x, int y, int a, int b, COLOR);
void 	EllipseFill				(int x, int y, int a, int b, COLOR);
void 	EllipseFillClip			(int x, int y, int a, int b, COLOR);
void 	EllipsePattern			(int x, int y, int a, int b, PATTERN);
void 	EllipsePatternClip		(int x, int y, int a, int b, PATTERN);
void 	EllipseFillPattern		(int x, int y, int a, int b, PATTERN);
void 	EllipseFillPatternClip	(int x, int y, int a, int b, PATTERN);

void 	Text					(int X, int Y, char *TEXT, COLOR);
BOOL 	PCX_Read				(char *fname);
//void	FloodFill				(int wx,int wy,int notcol,int col);


enum curstype {
		Standard, UpArrow, LeftArrow, CheckMark, PointingHand, DiagonalCross,
		RectangularCross, HourGlass, UserDef1, UserDef2, UserDef3, UserDef4
	};
extern struct {
		unsigned char bitmap[8];
		unsigned char HorizHotSpot;
		unsigned char VertHotSpot;
	} UserDefCurs1,UserDefCurs2,UserDefCurs3,UserDefCurs4;
extern unsigned int MouseX, MouseY;
extern unsigned int MPresent, MouseKey;
BOOL	MouseInit				(int MouseX, int MouseY, COLOR);
void	MouseUnInit				(void);
void 	MouseShowCursor			(void);
void 	MouseHideCursor			(void);
void 	MouseSetCursorShape		(enum curstype thetype);
void 	SetMousePort			(int x0, int y0, int x1, int y1);
BOOL 	MouseNonePressed		(void);
BOOL 	MouseLeftPressed		(void);
BOOL 	MouseRightPressed		(void);
BOOL 	MouseCenterPressed		(void);
BOOL 	MouseCenterLeftPressed	(void);
BOOL 	MouseCenterRightPressed	(void);
BOOL 	MouseAllPressed			(void);
void	MouseSetPage			(VRAM_PTR mpageoffset);

typedef struct {
	int ImageWidth;
	VRAM_PTR ImagePtr;
	char *MaskPtr;
} AlignedMaskedImage;

typedef struct {
	AlignedMaskedImage	*Alignments[4];
} MaskedImage;

void CopySystemToScreenMasked(int, int, int, int, int, int,
	char *, VRAM_PTR, int, int, char *);
	/* (SourceStartX, SourceStartY, SourceEndX, SourceEndY,
		DestStartX, DestStartY,
		SourcePtr, DestPageBase, SourceBitmapWidth, DestBitmapWidth,
		MaskPtr) */

extern void CopySystemToScreen(int, int, int, int, int, int, char*, VRAM_PTR,
	int, int);
	/* (SourceStartX, SourceStartY, SourceEndX, SourceEndY,
		DestStartX, DestStartY,
		SourcePtr, DestPageBase, SourceBitmapWidth, DestBitmapWidth) */

extern void CopyScreenToScreenMaskedX(int, int, int, int, int, int,
	 int, int, char far*);
	/* (SourceStartX, SourceStartY, SourceEndX, SourceEndY,
		DestStartX, DestStartY,
		ImageWidth, ImagePtr, DestPageBase, DestBitmapWidth) */

void CopyScreenToScreenMasked(int SourceStartX, int SourceStartY,
	int SourceEndX, int SourceEndY,	int DestStartX, int DestStartY,
	MaskedImage *Source, VRAM_PTR DestPageBase, int DestWidth);


extern void CopyScreenToScreen(int, int, int, int, int, int,
	VRAM_PTR, VRAM_PTR, int, int);
	/* (SourceStartX, SourceStartY, SourceEndX, SourceEndY,
	DestStartX, DestStartY, SourcePageBase, DestPageBase,
	SourceBitmapWidth, DestBitmapWidth) */

void CreateAlignedMaskedImage(MaskedImage *ImageToSet, char *Image,
		int ImageWidth,	int ImageHeight, char *Mask);

#ifdef __cplusplus
}
#endif

#define ALIGN_DWORD(x) (((x)+3)/4 * 4)
struct PCXRGB { BYTE r, g, b; };
struct PCXHeader {
	BYTE     Manufacturer;
	BYTE     Version;
	BYTE     Encoding;
	BYTE     BitsPixel;
	int      Xmin, Ymin;
	int      Xmax, Ymax;
	int      Hres, Vres;
//	PCXRGB   Palette[16];
	BYTE     Palette[48];
	BYTE     Reserved;
	BYTE     NPlanes;
	int      BytesLine;
	int      PaletteInfo;
	BYTE     Filler[58];
};


#endif
#pragma hdrstop