/**************************************************************************
 * PALETTE.C
 *
 * Set VGA RGB palette
 *************************************************************************/

#include "hobbes.h"

void VGA_fadein(WORD count, BYTE far *p1, BYTE far *p2);
void VGA_fadeout(WORD count, BYTE far *p1, BYTE far *p2);


/*********************************************************************
 * Fade colors from the given palette into black using 'count' steps.
 * The given 'palette' array is not modified.
 ********************************************************************/
void FadeOut(int count, COLOR palette[256][3])
{
	BYTE temp_pal[3*256];
	VGA_fadeout(count,palette,temp_pal);
}

/*********************************************************************
 * Fade colors from black to the given palette using 'count' steps.
 * The given 'palette' array is not modified.
 ********************************************************************/
void FadeIn(int count, COLOR palette[256][3])
{
	BYTE temp_pal[3*256];
	VGA_fadein(count,palette,temp_pal);
}
