#include<stdio.h>
#include<alloc.h>
#include "hobbes.h"
#include "pcx.h"

void PCXReadLine(FILE *fptr, PCXHeader *header, int posX, int posY);
//void DecodeMonoPCX(FILE *fptr, PCXHeader *header);
//void Decode16PCX(FILE *fptr, PCXHeader *header);
void Decode256PCX(FILE *fptr, PCXHeader *header, int, int);

extern TScreen *Screen;

BOOL PCX_Read(char *fname)
{
	FILE *fptr;
	PCXHeader header;
	int height, width;
	int test;

	if ((fptr = fopen(fname,"rb")) == NULL)
		return FALSE;

	fseek(fptr,0,SEEK_END);
	test = ftell(fptr);
	fseek(fptr,0,SEEK_SET);
	test = fread(&header, sizeof(PCXHeader), 1, fptr);
	test = ftell(fptr);

//	if (header.Manufacturer != 0x0a)
//		return FALSE;

	width  = header.Xmax - header.Xmin + 1;
	height = header.Ymax - header.Ymin + 1;


	if (header.BitsPixel == 8 && header.NPlanes == 1)
		Decode256PCX(fptr, &header, width, height);
/*
	  else
	if (header.BitsPixel == 1 && header.NPlanes == 4)
		Decode16PCX(fptr, &header);
	  else
	if (header.BitsPixel == 1 && header.NPlanes == 1)
		DecodeMonoPCX(fptr, &header);
*/
	  else
		return FALSE;

	fclose(fptr);
	return TRUE;
}


void Decode256PCX(FILE *fptr, PCXHeader *header, int width, int height) {

	int pX=0;
	int pY=0;

	for (pY=0; pY<height; pY++) {
		PCXReadLine(fptr, header, pX, pY);
		}

	// Load palette, if necessary
	fseek(fptr,769,SEEK_END);
	if (fgetc(fptr) == 0xc) {
		for(int i=0;i<256;i++) {
			Set1Palette(i,fgetc(fptr),fgetc(fptr),fgetc(fptr));
			}
		}


}



void PCXReadLine(FILE *fptr, PCXHeader *header, int posX, int posY)
{
	int data,
		count,
		offset=0;

	while (offset < header->BytesLine) {
		data = getc(fptr);

		if ((data & 0xC0) == 0xC0) {
			count = data & 0x3f;
			data = getc(fptr);
			Screen->HLine(posX, posX+count, posY, data);
			posX += count;
			offset += count;
			}
		else {
			Screen->Pixel(posX, posY, data);
			offset++;
			posX++;
			}
		}
}


