include hobbes.inc
include extrn.inc

EXTRN _HLineClip, _HLineClipR

.CODE
;-----------------------------------------------------------------------
; void TriangleFill(int X0, int Y0, int X1, int Y1, int X2, int Y2, COLOR);

		public  _TriangleFill
_TriangleFill       proc    far
ARG X0:WORD, Y0:WORD, X1:WORD, Y1:WORD, X2:WORD, Y2:WORD, COLOR:WORD
LOCAL DX01:WORD, DY01:WORD, DX02:WORD, DY02:WORD, DX12:WORD, DY12:WORD, \
	DP01:WORD, DP02:WORD, DP12:WORD, XA01:WORD, XA02:WORD, XA12:WORD=LocalStack
		push    bp
		mov     bp,sp
		sub     sp,LocalStack
		push    ds
		push    si
		push    di

		mov		ax,@data
		mov		ds,ax

		mov     ax,X0
		mov     bx,Y0
		mov     cx,X1
		mov     dx,Y1

		cmp     bx,dx   ; Y0,Y1
		jl      @@tri_Y0lY1
		je      @@tri_Y0eY1
		xchg    ax,cx   ; X0,X1
		xchg    bx,dx   ; Y0,Y1
@@tri_Y0lY1:
		cmp     dx,Y2   ; Y1,Y2
		jg      @@tri_a
		jmp     @@tri_sorted
@@tri_a:
		xchg    cx,X2   ; X1,X2
		xchg    dx,Y2   ; Y1,Y2
		cmp     bx,dx   ; Y0,Y1
		jge     @@tri_b
		jmp     @@tri_sorted
@@tri_b:
		je      @@tri_bot
		xchg    ax,cx   ; X0,X1
		xchg    bx,dx   ; Y0,Y1
		jmp     @@tri_sorted
@@tri_Y0eY1:
		cmp     bx,Y2   ; Y0,Y2
		jl      @@tri_bot
		jg      @@tri_c
		jmp     @@tri_done
@@tri_c:
		xchg    ax,X2   ; X0,X2
		xchg    bx,Y2   ; Y0,Y2
		jmp     @@tri_sorted

@@tri_bot:
		cmp     ax,cx   ; X0,X1
		jl      @@tri_bot_sorted
		jg      @@tri_bot_a
		jmp     @@tri_done
@@tri_bot_a:
		xchg    ax,cx   ; X0,X1
@@tri_bot_sorted:
		cmp     bx,_ClipBottom
		jle     @@tri_bot_y0ok
		jmp     @@tri_done
@@tri_bot_y0ok:
		mov     si,Y2
		cmp     si,_ClipTop
		jge     @@tri_bot_y2ok
		jmp     @@tri_done
@@tri_bot_y2ok:
		mov     X0,ax
		mov     Y0,bx
		mov     X1,cx
		mov     Y1,dx

		mov     bx,Y2   ;    bx <- Y2
		sub     bx,Y0   ;    bx <- Y2 - Y0
		mov     DY02,bx ;  DY02 <- Y2 - Y0
		mov     ax,X2   ;    ax <- X2
		sub     ax,X0   ;    ax <- X2 - X0
		mov     DX02,ax ;  DX02 <- X2 - X0
		mov     cx,ax   ;    cx <- DX02
		cwd             ; dx:ax <- DX02
		idiv    bx      ;    ax <- DX02 / DY02
		cmp     cx,0
		jge     short @@tri_bot02
		dec     ax      ;    ax <- DX02 / DY02 - 1
@@tri_bot02:
		mov     XA02,ax ;  XA02 <- DX02 / DY02
		imul    bx      ;    ax <- XA02 * DY02
		sub     cx,ax   ;    cx <- DX02 - XA02 * DY02
		mov     DP02,cx ;  DP02 <- DX02 - XA02 * DY02

		mov     bx,Y2   ;    bx <- Y2
		sub     bx,Y1   ;    bx <- Y2 - Y1
		mov     DY12,bx ;  DY02 <- Y2 - Y1
		mov     ax,X2   ;    ax <- X2
		sub     ax,X1   ;    ax <- X2 - X1
		mov     DX12,ax ;  DX12 <- X2 - X1
		mov     cx,ax   ;    cx <- DX12
		cwd             ; dx:ax <- DX12
		idiv    bx      ;    ax <- DX12 / DY12
		cmp     cx,0
		jge     short @@tri_bot12
		dec     ax      ;    ax <- DX12 / DY12 - 1
@@tri_bot12:
		mov     XA12,ax ;  XA12 <- DX12 / DY12
		imul    bx      ;    ax <- XA12 * DY12
		sub     cx,ax   ;    cx <- DX12 - XA12 * DY12
		mov     DP12,cx ;  DP12 <- DX12 - XA12 * DY12

		mov     ax,0    ; PL <- 0
		mov     bx,0    ; PS <- 0
		mov     cx,Y0   ;  Y <- Y0
		mov     si,X0
		mov     di,X1
		dec     di
@@tri_bot_loop:
		inc     cx      ; Y

		add     ax,DP02 ; PL,DP02
		jle     short @@tri_bot_shortl
		sub     ax,DY02 ; PL,DY02
		inc     si      ; XL
@@tri_bot_shortl:
		add     si,XA02 ; XL,XA02

		add     bx,DP12 ; PS,DP12
		jle     short @@tri_bot_shortr
		sub     bx,DY12 ; PS,DY12
		inc     di      ; XS
@@tri_bot_shortr:
		add     di,XA12 ; XS,XA12

		push    di      ; XS
		push    si      ; XL
		cmp     cx,Y2   ; Y,Y2
		jl      short @@tri_bot_loop

		jmp     @@tri_draw_lines


@@tri_sorted:
		cmp     bx,_ClipBottom
		jle     @@tri_y0ok
		jmp     @@tri_done
@@tri_y0ok:
		mov     si,Y2
		cmp     si,_ClipTop
		jge     @@tri_y2ok
		jmp     @@tri_done
@@tri_y2ok:
		mov     X0,ax
		mov     Y0,bx
		mov     X1,cx
		mov     Y1,dx

		mov     bx,dx   ;    bx <- Y1
		sub     bx,Y0   ;    bx <- Y1 - Y0
		mov     DY01,bx ;  DY01 <- Y1 - Y0
		mov     ax,X1   ;    ax <- X1
		sub     ax,X0   ;    ax <- X1 - X0
		mov     DX01,ax ;  DX01 <- X1 - X0
		mov     cx,ax   ;    cx <- DX01
		cwd             ; dx:ax <- DX01
		idiv    bx      ;    ax <- DX01 / DY01
		cmp     cx,0    ;  DX01 ? 0
		jge     short @@tri_psl01
		dec     ax      ;    ax <- DX01 / DY01 - 1
@@tri_psl01:
		mov     XA01,ax ;  XA01 <- DX01 / DY01
		imul    bx      ;    ax <- XA01 * DY01
		sub     cx,ax   ;    cx <- DX01 - XA01 * DY01
		mov     DP01,cx ;  DP01 <- DX01 - XA01 * DY01

		mov     bx,Y2   ;    bx <- Y2
		sub     bx,Y0   ;    bx <- Y2 - Y0
		mov     DY02,bx ;  DY02 <- Y2 - Y0
		mov     ax,X2   ;    ax <- X2
		sub     ax,X0   ;    ax <- X2 - X0
		mov     DX02,ax ;  DX02 <- X2 - X0
		mov     cx,ax   ;    cx <- DX02
		cwd             ; dx:ax <- DX02
		idiv    bx      ;    ax <- DX02 / DY02
		cmp     cx,0
		jge     short @@tri_psl02
		dec     ax      ;    ax <- DX02 / DY02 - 1
@@tri_psl02:
		mov     XA02,ax ;  XA02 <- DX02 / DY02
		imul    bx      ;    ax <- XA02 * DY02
		sub     cx,ax   ;    cx <- DX02 - XA02 * DY02
		mov     DP02,cx ;  DP02 <- DX02 - XA02 * DY02

		mov     bx,Y2   ;    bx <- Y2
		sub     bx,Y1   ;    bx <- Y2 - Y1
		jle     short @@tri_const_computed
		mov     DY12,bx ;  DY12 <- Y2 - Y1
		mov     ax,X2   ;    ax <- X2
		sub     ax,X1   ;    ax <- X2 - X1
		mov     DX12,ax ;  DX12 <- X2 - X1
		mov     cx,ax   ;    cx <- DX12
		cwd             ; dx:ax <- DX12
		idiv    bx      ;    ax <- DX12 / DY12
		cmp     cx,0
		jge     short @@tri_psl12
		dec     ax      ;    ax <- DX12 / DY12 - 1
@@tri_psl12:
		mov     XA12,ax ;  XA12 <- DX12 / DY12
		imul    bx      ;    ax <- XA12 * DY12
		sub     cx,ax   ;    cx <- DX12 - XA12 * DY12
		mov     DP12,cx ;  DP12 <- DX12 - XA12 * DY12

@@tri_const_computed:
		mov     ax,DX01
		imul    word ptr DY02
		mov     bx,ax
		mov     cx,dx   ; DX01 * DY02 in cx:bx

		mov     ax,DX02
		imul    word ptr DY01 ; DX02 * DY01 in dx:ax
		cmp     cx,dx
		jg      @@tri_pt1rt
		jl      @@tri_pt1lt
		cmp     bx,ax
		ja      @@tri_pt1rt
		jb      @@tri_pt1lt
		jmp     @@tri_done

; Short sides are on the left
;
@@tri_pt1lt:
		mov     ax,0    ; PL <- 0
		mov     bx,0    ; PS <- 0
		mov     cx,Y0   ;  Y <- Y0
		mov     si,X0
		mov     di,si
		dec     si
@@tri_lt_loop:
		inc     cx      ; Y

		add     ax,DP02 ; PL,DP02
		jle     short @@tri_lt_shortl
		sub     ax,DY02 ; PL,DY02
		inc     si      ; XL
@@tri_lt_shortl:
		add     si,XA02 ; XL,XA02

		add     bx,DP01 ; PS,DP01
		jle     short @@tri_lt_shortr
		sub     bx,DY01 ; PS,DY01
		inc     di      ; XS
@@tri_lt_shortr:
		add     di,XA01 ; XS,XA01

		push    si      ; XL
		push    di      ; XS
		cmp     cx,Y1   ; Y,Y1
		jl      short @@tri_lt_loop

		jmp     short @@tri_lb_start
@@tri_lb_loop:
		inc     cx      ; Y

		add     ax,DP02 ; PL,DP02
		jle     short @@tri_lb_shortl
		sub     ax,DY02 ; PL,DY02
		inc     si      ; XL
@@tri_lb_shortl:
		add     si,XA02 ; XL,XA02

		add     bx,DP12 ; PS,DP12
		jle     short @@tri_lb_shortr
		sub     bx,DY12 ; PS,DY12
		inc     di      ; XS
@@tri_lb_shortr:
		add     di,XA12 ; XS,XA12

		push    si      ; XL
		push    di      ; XS
@@tri_lb_start:
		cmp     cx,Y2   ; Y,Y2
		jl      @@tri_lb_loop
		jmp     short @@tri_draw_lines

; short sides are on the right
;
@@tri_pt1rt:
		mov     ax,0    ; PL <- 0
		mov     bx,0    ; PS <- 0
		mov     cx,Y0   ;  Y <- Y0
		mov     si,X0
		mov     di,si
		dec     di
@@tri_rt_loop:
		inc     cx      ; Y

		add     ax,DP02 ; PL,DP02
		jle     short @@tri_rt_shortl
		sub     ax,DY02 ; PL,DY02
		inc     si      ; XL
@@tri_rt_shortl:
		add     si,XA02 ; XL,XA02

		add     bx,DP01 ; PS,DP01
		jle     short @@tri_rt_shortr
		sub     bx,DY01 ; PS,DY01
		inc     di      ; XS
@@tri_rt_shortr:
		add     di,XA01 ; XS,XA01

		push    di      ; XS
		push    si      ; XL
		cmp     cx,Y1   ; Y,Y1
		jl      short @@tri_rt_loop

		jmp     short @@tri_rb_start
@@tri_rb_loop:
		inc     cx      ; Y

		add     ax,DP02 ; PL,DP02
		jle     short @@tri_rb_shortl
		sub     ax,DY02 ; PL,DY02
		inc     si      ; XL
@@tri_rb_shortl:
		add     si,XA02 ; XL,XA02

		add     bx,DP12 ; PS,DP12
		jle     short @@tri_rb_shorts
		sub     bx,DY12 ; PS,DY12
		inc     di      ; XS
@@tri_rb_shorts:
		add     di,XA12 ; XS,XA12

		push    di      ; XS
		push    si      ; XL
@@tri_rb_start:
		cmp     cx,Y2   ; Y,Y2
		jl      short @@tri_rb_loop

; Draw the horizontal lines
;
@@tri_draw_lines:
		pop     ax
		pop     dx
		cmp     ax,dx
		jg      @@tri_draw_next
		mov     bx,COLOR
		mov     cx,Y2
		call    far ptr _HLineClipR
@@tri_draw_next:
		dec     word ptr Y2
		dec     word ptr DY02
		jnz     @@tri_draw_lines

@@tri_done:
		pop     di
		pop     si
		pop     ds
		mov     sp,bp
		pop     bp
		ret
_TriangleFill       endp






;----------------------------------------------------------------------------
; void TriangleFillClip(int X0, int Y0, int X1, int Y1, int X2, int Y2, COLOR);

		public  _TriangleFillClip
_TriangleFillClip   proc    far
ARG X0:WORD, Y0:WORD, X1:WORD, Y1:WORD, X2:WORD, Y2:WORD, COLOR:WORD
LOCAL DX01:WORD, DY01:WORD, DX02:WORD, DY02:WORD, DX12:WORD, DY12:WORD, \
	DP01:WORD, DP02:WORD, DP12:WORD, XA01:WORD, XA02:WORD, XA12:WORD=LocalStack
		push    bp
		mov     bp,sp
		sub     sp,LocalStack
		push    ds
		push    si
		push    di

		mov     ax,X0
		mov     bx,Y0
		mov     cx,X1
		mov     dx,Y1

		cmp     bx,dx   ; Y0,Y1
		jl      @@ctri_Y0lY1
		je      @@ctri_Y0eY1
		xchg    ax,cx   ; X0,X1
		xchg    bx,dx   ; Y0,Y1
@@ctri_Y0lY1:
		cmp     dx,Y2   ; Y1,Y2
		jg      @@ctri_a
		jmp     @@ctri_sorted
@@ctri_a:
		xchg    cx,X2   ; X1,X2
		xchg    dx,Y2   ; Y1,Y2
		cmp     bx,dx   ; Y0,Y1
		jge     @@ctri_b
		jmp     @@ctri_sorted
@@ctri_b:
		je      @@ctri_bot
		xchg    ax,cx   ; X0,X1
		xchg    bx,dx   ; Y0,Y1
		jmp     @@ctri_sorted
@@ctri_Y0eY1:
		cmp     bx,Y2   ; Y0,Y2
		jl      @@ctri_bot
		jg      @@ctri_c
		jmp     @@ctri_done
@@ctri_c:
		xchg    ax,X2   ; X0,X2
		xchg    bx,Y2   ; Y0,Y2
		jmp     @@ctri_sorted

@@ctri_bot:
		cmp     ax,cx   ; X0,X1
		jl      @@ctri_bot_sorted
		jg      @@ctri_bot_a
		jmp     @@ctri_done
@@ctri_bot_a:
		xchg    ax,cx   ; X0,X1
@@ctri_bot_sorted:
		cmp     bx,_ClipBottom
		jle     @@ctri_bot_y0ok
		jmp     @@ctri_done
@@ctri_bot_y0ok:
		mov     si,Y2
		cmp     si,_ClipTop
		jge     @@ctri_bot_y2ok
		jmp     @@ctri_done
@@ctri_bot_y2ok:
		mov     X0,ax
		mov     Y0,bx
		mov     X1,cx
		mov     Y1,dx

		mov     bx,Y2   ;    bx <- Y2
		sub     bx,Y0   ;    bx <- Y2 - Y0
		mov     DY02,bx ;  DY02 <- Y2 - Y0
		mov     ax,X2   ;    ax <- X2
		sub     ax,X0   ;    ax <- X2 - X0
		mov     DX02,ax ;  DX02 <- X2 - X0
		mov     cx,ax   ;    cx <- DX02
		cwd             ; dx:ax <- DX02
		idiv    bx      ;    ax <- DX02 / DY02
		cmp     cx,0
		jge     short @@ctri_bot02
		dec     ax      ;    ax <- DX02 / DY02 - 1
@@ctri_bot02:
		mov     XA02,ax ;  XA02 <- DX02 / DY02
		imul    bx      ;    ax <- XA02 * DY02
		sub     cx,ax   ;    cx <- DX02 - XA02 * DY02
		mov     DP02,cx ;  DP02 <- DX02 - XA02 * DY02

		mov     bx,Y2   ;    bx <- Y2
		sub     bx,Y1   ;    bx <- Y2 - Y1
		mov     DY12,bx ;  DY02 <- Y2 - Y1
		mov     ax,X2   ;    ax <- X2
		sub     ax,X1   ;    ax <- X2 - X1
		mov     DX12,ax ;  DX12 <- X2 - X1
		mov     cx,ax   ;    cx <- DX12
		cwd             ; dx:ax <- DX12
		idiv    bx      ;    ax <- DX12 / DY12
		cmp     cx,0
		jge     short @@ctri_bot12
		dec     ax      ;    ax <- DX12 / DY12 - 1
@@ctri_bot12:
		mov     XA12,ax ;  XA12 <- DX12 / DY12
		imul    bx      ;    ax <- XA12 * DY12
		sub     cx,ax   ;    cx <- DX12 - XA12 * DY12
		mov     DP12,cx ;  DP12 <- DX12 - XA12 * DY12

		mov     ax,0    ; PL <- 0
		mov     bx,0    ; PS <- 0
		mov     cx,Y0   ;  Y <- Y0
		mov     si,X0
		mov     di,X1
		dec     di
@@ctri_bot_loop:
		inc     cx      ; Y

		add     ax,DP02 ; PL,DP02
		jle     short @@ctri_bot_shortl
		sub     ax,DY02 ; PL,DY02
		inc     si      ; XL
@@ctri_bot_shortl:
		add     si,XA02 ; XL,XA02

		add     bx,DP12 ; PS,DP12
		jle     short @@ctri_bot_shortr
		sub     bx,DY12 ; PS,DY12
		inc     di      ; XS
@@ctri_bot_shortr:
		add     di,XA12 ; XS,XA12

		push    di      ; XS
		push    si      ; XL
		cmp     cx,Y2   ; Y,Y2
		jl      short @@ctri_bot_loop

		jmp     @@ctri_draw_lines


@@ctri_sorted:
		cmp     bx,_ClipBottom
		jle     @@ctri_y0ok
		jmp     @@ctri_done
@@ctri_y0ok:
		mov     si,Y2
		cmp     si,_ClipTop
		jge     @@ctri_y2ok
		jmp     @@ctri_done
@@ctri_y2ok:
		mov     X0,ax
		mov     Y0,bx
		mov     X1,cx
		mov     Y1,dx

		mov     bx,dx   ;    bx <- Y1
		sub     bx,Y0   ;    bx <- Y1 - Y0
		mov     DY01,bx ;  DY01 <- Y1 - Y0
		mov     ax,X1   ;    ax <- X1
		sub     ax,X0   ;    ax <- X1 - X0
		mov     DX01,ax ;  DX01 <- X1 - X0
		mov     cx,ax   ;    cx <- DX01
		cwd             ; dx:ax <- DX01
		idiv    bx      ;    ax <- DX01 / DY01
		cmp     cx,0    ;  DX01 ? 0
		jge     short @@ctri_psl01
		dec     ax      ;    ax <- DX01 / DY01 - 1
@@ctri_psl01:
		mov     XA01,ax ;  XA01 <- DX01 / DY01
		imul    bx      ;    ax <- XA01 * DY01
		sub     cx,ax   ;    cx <- DX01 - XA01 * DY01
		mov     DP01,cx ;  DP01 <- DX01 - XA01 * DY01

		mov     bx,Y2   ;    bx <- Y2
		sub     bx,Y0   ;    bx <- Y2 - Y0
		mov     DY02,bx ;  DY02 <- Y2 - Y0
		mov     ax,X2   ;    ax <- X2
		sub     ax,X0   ;    ax <- X2 - X0
		mov     DX02,ax ;  DX02 <- X2 - X0
		mov     cx,ax   ;    cx <- DX02
		cwd             ; dx:ax <- DX02
		idiv    bx      ;    ax <- DX02 / DY02
		cmp     cx,0
		jge     short @@ctri_psl02
		dec     ax      ;    ax <- DX02 / DY02 - 1
@@ctri_psl02:
		mov     XA02,ax ;  XA02 <- DX02 / DY02
		imul    bx      ;    ax <- XA02 * DY02
		sub     cx,ax   ;    cx <- DX02 - XA02 * DY02
		mov     DP02,cx ;  DP02 <- DX02 - XA02 * DY02

		mov     bx,Y2   ;    bx <- Y2
		sub     bx,Y1   ;    bx <- Y2 - Y1
		jle     short @@ctri_const_computed
		mov     DY12,bx ;  DY12 <- Y2 - Y1
		mov     ax,X2   ;    ax <- X2
		sub     ax,X1   ;    ax <- X2 - X1
		mov     DX12,ax ;  DX12 <- X2 - X1
		mov     cx,ax   ;    cx <- DX12
		cwd             ; dx:ax <- DX12
		idiv    bx      ;    ax <- DX12 / DY12
		cmp     cx,0
		jge     short @@ctri_psl12
		dec     ax      ;    ax <- DX12 / DY12 - 1
@@ctri_psl12:
		mov     XA12,ax ;  XA12 <- DX12 / DY12
		imul    bx      ;    ax <- XA12 * DY12
		sub     cx,ax   ;    cx <- DX12 - XA12 * DY12
		mov     DP12,cx ;  DP12 <- DX12 - XA12 * DY12

@@ctri_const_computed:
		mov     ax,DX01
		imul    word ptr DY02
		mov     bx,ax
		mov     cx,dx   ; DX01 * DY02 in cx:bx

		mov     ax,DX02
		imul    word ptr DY01 ; DX02 * DY01 in dx:ax
		cmp     cx,dx
		jg      @@ctri_pt1rt
		jl      @@ctri_pt1lt
		cmp     bx,ax
		ja      @@ctri_pt1rt
		jb      @@ctri_pt1lt
		jmp     @@ctri_done

; Short sides are on the left
;
@@ctri_pt1lt:
		mov     ax,0    ; PL <- 0
		mov     bx,0    ; PS <- 0
		mov     cx,Y0   ;  Y <- Y0
		mov     si,X0
		mov     di,si
		dec     si
@@ctri_lt_loop:
		inc     cx      ; Y

		add     ax,DP02 ; PL,DP02
		jle     short @@ctri_lt_shortl
		sub     ax,DY02 ; PL,DY02
		inc     si      ; XL
@@ctri_lt_shortl:
		add     si,XA02 ; XL,XA02

		add     bx,DP01 ; PS,DP01
		jle     short @@ctri_lt_shortr
		sub     bx,DY01 ; PS,DY01
		inc     di      ; XS
@@ctri_lt_shortr:
		add     di,XA01 ; XS,XA01

		push    si      ; XL
		push    di      ; XS
		cmp     cx,Y1   ; Y,Y1
		jl      short @@ctri_lt_loop

		jmp     short @@ctri_lb_start
@@ctri_lb_loop:
		inc     cx      ; Y

		add     ax,DP02 ; PL,DP02
		jle     short @@ctri_lb_shortl
		sub     ax,DY02 ; PL,DY02
		inc     si      ; XL
@@ctri_lb_shortl:
		add     si,XA02 ; XL,XA02

		add     bx,DP12 ; PS,DP12
		jle     short @@ctri_lb_shortr
		sub     bx,DY12 ; PS,DY12
		inc     di      ; XS
@@ctri_lb_shortr:
		add     di,XA12 ; XS,XA12

		push    si      ; XL
		push    di      ; XS
@@ctri_lb_start:
		cmp     cx,Y2   ; Y,Y2
		jl      @@ctri_lb_loop
		jmp     short @@ctri_draw_lines

; short sides are on the right
;
@@ctri_pt1rt:
		mov     ax,0    ; PL <- 0
		mov     bx,0    ; PS <- 0
		mov     cx,Y0   ;  Y <- Y0
		mov     si,X0
		mov     di,si
		dec     di
@@ctri_rt_loop:
		inc     cx      ; Y

		add     ax,DP02 ; PL,DP02
		jle     short @@ctri_rt_shortl
		sub     ax,DY02 ; PL,DY02
		inc     si      ; XL
@@ctri_rt_shortl:
		add     si,XA02 ; XL,XA02

		add     bx,DP01 ; PS,DP01
		jle     short @@ctri_rt_shortr
		sub     bx,DY01 ; PS,DY01
		inc     di      ; XS
@@ctri_rt_shortr:
		add     di,XA01 ; XS,XA01

		push    di      ; XS
		push    si      ; XL
		cmp     cx,Y1   ; Y,Y1
		jl      short @@ctri_rt_loop

		jmp     short @@ctri_rb_start
@@ctri_rb_loop:
		inc     cx      ; Y

		add     ax,DP02 ; PL,DP02
		jle     short @@ctri_rb_shortl
		sub     ax,DY02 ; PL,DY02
		inc     si      ; XL
@@ctri_rb_shortl:
		add     si,XA02 ; XL,XA02

		add     bx,DP12 ; PS,DP12
		jle     short @@ctri_rb_shorts
		sub     bx,DY12 ; PS,DY12
		inc     di      ; XS
@@ctri_rb_shorts:
		add     di,XA12 ; XS,XA12

		push    di      ; XS
		push    si      ; XL
@@ctri_rb_start:
		cmp     cx,Y2   ; Y,Y2
		jl      short @@ctri_rb_loop

; Draw the horizontal lines
;
@@ctri_draw_lines:
		pop     ax
		pop     dx
		cmp     ax,dx
		jg      @@ctri_draw_next
		mov     bx,COLOR
		mov     cx,Y2
		call    far ptr _HLineClipR
@@ctri_draw_next:
		dec     word ptr Y2
		dec     word ptr DY02
		jnz     @@ctri_draw_lines

@@ctri_done:
		pop     di
		pop     si
		pop     ds
		mov     sp,bp
		pop     bp
		ret
_TriangleFillClip       endp


END