// Hobbes ModeX Library
// Copyright (c) 1992 Court Demas

#include <stdlib.h>
#include <conio.h>
#include "hobbes.h"

void SetVirtualPort(int x, int y) {
	int i;
	Virtual_Width_Pix = x;
	Virtual_Height_Pix = y;
	Virtual_Width_Addr = x / 4;
	Virtual_Height_Addr = y / 4;
	Virtual_Size = ((long)Virtual_Width_Addr * Virtual_Height_Pix); // 4;
	Page0_Offset = Split_Line * Virtual_Width_Addr;
	Page1_Offset = Page0_Offset + Virtual_Size;
	outp(CRTC_INDEX, OFFSET);
	outp(CRTC_INDEX+1, Virtual_Width_Addr/2);
	for(i=0;i<512;i++) {
		RowOffset[i] = (unsigned) i*Virtual_Width_Addr;
		}
}

void DrawOnSplit(void) {
	Draw_Offset = Split_Offset;
}

void DrawOnScreen(void) {
	if (Current_Page==0)
		Draw_Offset = Page0_Offset;
	  else
		Draw_Offset = Page1_Offset;
}

/*
void 	FlipPage(void) {
	Display_Offset = Draw_Offset;
	Draw_Offset = Draw_Offset ^ Virtual_Size;
	SwapPage();
	ShowPage(Display_Offset);
}
*/

//---------------------------------------------------------------------------
// End of Hobbes.c