#include <io.h>
#include <mio.h>
#include <mgr.h>
#include <mmulle.h>
#include <mevent.h>
#include <mwin.h>
#include <mparent.h>
#include <mcontrol.h>
#include <stdarg.h>
#include "draw.h"

/********************************************/
 WORD           NewPixmap (...)
/********************************************/
{
Canvas * DrawSpace;
    DrawSpace = (Canvas*) root.Find (CANVAS_HANDLE);
    DrawSpace->pixmap->Clear();
    CreateEvent (REFRESH_WINDOW, 0, NULL, 0L, CANVAS_HANDLE);
    return (EVENT_USED);
}

/********************************************/
 WORD           LoadPixmap (...)
/********************************************/
{
Canvas * DrawSpace;
    DrawSpace = (Canvas*) root.Find (CANVAS_HANDLE);
    AskFilename (DrawSpace->filename);
    if (access (DrawSpace->filename, 0) == 0)
       DrawSpace->pixmap->Load (DrawSpace->filename);
    DrawSpace->ResizeWorld (DrawSpace->pixmap->GetLength(), DrawSpace->pixmap->GetWidth());
    return (EVENT_USED);
}

/********************************************/
 WORD           SavePixmap (...)
/********************************************/
{
Canvas * DrawSpace;
    DrawSpace = (Canvas*) root.Find (CANVAS_HANDLE);
    AskFilename (DrawSpace->filename);
    DrawSpace->pixmap->Save (DrawSpace->filename);
    return (EVENT_USED);
}

/********************************************/
 WORD           ResizePixmap (...)
/********************************************/
{
Canvas * DrawSpace;
WORD length, width;
    DrawSpace = (Canvas*) root.Find (CANVAS_HANDLE);
    length = DrawSpace->pixmap->GetLength();
    width = DrawSpace->pixmap->GetWidth();
    AskSize (&length, &width);
    DrawSpace->pixmap->Redefine (length, width);
    DrawSpace->ResizeWorld (length, width);
    return (EVENT_USED);
}

/********************************************/
 WORD          ScrollPixmapUp (...)
/********************************************/
{
Canvas * DrawSpace;
    DrawSpace = (Canvas*) root.Find (CANVAS_HANDLE);
    DrawSpace->Scroll (Up);
    return (EVENT_USED);
}

/********************************************/
 WORD          ScrollPixmapDown (...)
/********************************************/
{
Canvas * DrawSpace;
    DrawSpace = (Canvas*) root.Find (CANVAS_HANDLE);
    DrawSpace->Scroll (Down);
    return (EVENT_USED);
}

/********************************************/
 WORD          ScrollPixmapLeft (...)
/********************************************/
{
Canvas * DrawSpace;
    DrawSpace = (Canvas*) root.Find (CANVAS_HANDLE);
    DrawSpace->Scroll (Left);
    return (EVENT_USED);
}

/********************************************/
 WORD          ScrollPixmapRight (...)
/********************************************/
{
Canvas * DrawSpace;
    DrawSpace = (Canvas*) root.Find (CANVAS_HANDLE);
    DrawSpace->Scroll (Right);
    return (EVENT_USED);
}

/********************************************/
 WORD            QuitApp (...)
/********************************************/
{
    return (SHELL_QUIT);
}

/********************************************/
 WORD           LoadDraw (...)
/********************************************/
{
MULLE datafile;
Canvas * DrawSpace;
    DrawSpace = (Canvas*) root.Find (CANVAS_HANDLE);
    DrawSpace->mode = DRAWING;

    datafile.SetMainFile ("draw.dat");
    mouse.Load ("draw.dat", datafile.GetOffset ("arrow.cur"));
    return (EVENT_USED);
}

/********************************************/
 WORD           LoadFill (...)
/********************************************/
{
MULLE datafile;
Canvas * DrawSpace;
    DrawSpace = (Canvas*) root.Find (CANVAS_HANDLE);
    DrawSpace->mode = FILLING;

    datafile.SetMainFile ("draw.dat");
    mouse.Load ("draw.dat", datafile.GetOffset ("fill.cur"));
    return (EVENT_USED);
}

/********************************************/
 WORD           LoadErase (...)
/********************************************/
{
MULLE datafile;
Canvas * DrawSpace;
    DrawSpace = (Canvas*) root.Find (CANVAS_HANDLE);
    DrawSpace->mode = ERASING;

    datafile.SetMainFile ("draw.dat");
    mouse.Load ("draw.dat", datafile.GetOffset ("erase.cur"));
    return (EVENT_USED);
}

/********************************************/
 WORD           LoadMagnify (...)
/********************************************/
{
MULLE datafile;
Canvas * DrawSpace;
    DrawSpace = (Canvas*) root.Find (CANVAS_HANDLE);
    DrawSpace->mode = MAGNIFYING;

    datafile.SetMainFile ("draw.dat");
    mouse.Load ("draw.dat", datafile.GetOffset ("magnify.cur"));
    return (EVENT_USED);
}

/********************************************/
 void            AskFilename
/********************************************/
(BYTE * Buffer)
{
RECT PromptBox (100,70,240,90);
RECT TypingBox (105,73,200,85);
RECT QuitBox (205,73,235,85);
MParent PromptBase (PromptBox, 0x100F, HROOT);
MGetInput Typer (TypingBox, "Filename: ", 13, 0x1010, 0x100F);
MButton OkButton (QuitBox, "Ok", 0x1011, 0x100F);

    Typer.SetBuffer (Buffer);
    OkButton.SetUserHandler (QuitApp);
    FinishSetup (0x100F);
    PromptBase.Realize();
    PromptBase.Run();
}

/********************************************/
 void              AskSize
/********************************************/
(WORD * length, WORD * width)
{
RECT PromptBox (100,70,220,110);
RECT TypingBox1 (105,73,170,85);
RECT TypingBox2 (105,93,170,105);
RECT QuitBox (180,73,215,105);
MParent PromptBase (PromptBox, 0x100F, HROOT);
MGetInput LengthTyper (TypingBox1, "Length: ", 4, 0x1010, 0x100F);
MGetInput WidthTyper (TypingBox2, "Width: ", 4, 0x1011, 0x100F);
MButton OkButton (QuitBox, "Ok", 0x1012, 0x100F);
BYTE LengthString[5];
BYTE WidthString[5];
int NewLength, NewWidth;

    LengthTyper.SetBuffer (LengthString);
    WidthTyper.SetBuffer (WidthString);
    OkButton.SetUserHandler (QuitApp);

    FinishSetup (0x100F);
    PromptBase.Realize();
    PromptBase.Run();

    LengthTyper.FlushToBuffer();
    WidthTyper.FlushToBuffer();

    if ((NewLength = atoi (LengthString)) > 0 && NewLength < MAXX)
       *length = NewLength;
    if ((NewWidth = atoi (WidthString)) > 0 && NewWidth < MAXY)
       *width = NewWidth;
}
