
#ifndef __MARRAY_H
#define __MARRAY_H

#define MINLEN               0      // Minimum array size
#define MARGIN               1      // Extra bytes to allocate

#define BARRAY_ID            0x0103
#define CARRAY_ID            0x0104
#define WARRAY_ID            0x0105

////////////////////////////// Bitmap class //////////////////////////////////

class bArray : public Atom {
    WORD                     length;
    WORD                     width;
public:
			     bArray (void);
			     bArray (WORD len, WORD wid = 1);
			     bArray (const bArray& arr);
    virtual BOOL             operator[] (WORD index);
    virtual BOOL             Read (WORD x, WORD y);
    virtual inline classType isA (void) {return (BARRAY_ID);};
    virtual void             Activate (WORD index);
    virtual void             Activate (WORD x, WORD y);
    virtual void             Activate (const RECT& area);
    virtual void             Deactivate (WORD index);
    virtual void             Deactivate (WORD x, WORD y);
    virtual void             Deactivate (const RECT& area);
    virtual void             Resize (SIZE n_Size);
			    ~bArray (void);
};
typedef bArray BARRAY;

///////////////////////// Character and word arrays //////////////////////////

class cArray : public Atom {
public:
			     cArray (void);
			     cArray (SIZE size);
			     cArray (WORD len, BYTE *arr);
			     cArray (const cArray& arr);
    virtual inline classType isA (void) {return (CARRAY_ID);};
    virtual BYTE&            operator[] (WORD index);
    operator                 BYTE*() const;
    friend cArray            operator+ (const cArray& a1, const cArray& a2);
    virtual cArray&          operator= (BYTE * string);
			    ~cArray (void);
};
typedef cArray CARRAY;

class wArray : public Atom {
public:
			     wArray (void);
			     wArray (SIZE size);
			     wArray (WORD len, WORD *arr);
			     wArray (const wArray& arr);
    virtual inline classType isA (void) {return (WARRAY_ID);};
    virtual WORD&            operator[] (WORD index);
    virtual operator         WORD*() const;
    friend wArray            operator+ (const wArray& a1, const wArray& a2);
       		            ~wArray (void);
};
typedef wArray WARRAY;

#endif
