
#ifndef __MGRAPH_H
#define __MGRAPH_H

#include <math.h>
#include <mfonts.h>
#include <maplane.h>
#include <mpal.h>

#define MAXX            320
#define MAXY            200
#define MASK_MAXX        40

#define EMPTY_FILL        0
#define SOLID_FILL        1
#define PATTERN_FILL      2

#define PATTERN_SIDE      5
#define PATTERN_SIZE     25

#define SCREEN_ADDRESS   (char far*)(0xA0000000L)
#define SCREEN_SIZE                  0xFA00
#define MASK_SIZE                    (SCREEN_SIZE / BITSPERBYTE)

#define MGRAPH_ID         0x010D

/////////////////////// PROTOTYPES ///////////////////////////////////////////

 void            bar (int left,int top,int right,int bottom);
 void            bar (const RECT& area);
 void            circle (int xpos,int ypos,unsigned int radius);
 void            fillcircle (int xpos,int ypos,unsigned int radius);
 void            cleardevice (void);
 void            clearviewport (void);
 BOOL            clipscreen (int *x, int *y);
 void            clipscreen (RECT *area);
 void            clipscreen (VP *area);
 void            setdpy (ADR address, WORD length, WORD width);
 void            setviewport (int left,int top,int right,int bottom);
 void            setviewport (const RECT& AView);
 void            moveto (int x,int y);
 int             outtextxy (int x,int y,char *string);
 void            drawpoly (WORD nPoints, POINT * polypoints);
 void            swap_fill_draw (void);
 void            setcolor (WORD new_color);
 int             getminx (void);
 int             getminy (void);
 int             getmaxx (void);
 int             getmaxy (void);
 void            push_DC (void);
 void            pop_DC (void);
 void            setfillstyle (int new_fill,int new_fill_color);
 void            initgraph (void);
 BOOL            IsInside (const RECT& area, int x, int y);
 void            closegraph (void);
 int             getcolor (void);
 int             getpixel (int x,int y);
 void            get_rect_back (int left, int top, int right,
				int bottom, BYTE *image);
 void            hor_line (int from,int to,int level);
 void            lineto (int to_x, int to_y);
 void            linerel (int dx, int dy);
 void            line (int left,int top,int right,int bottom);
 void            putpixel (int x,int y);
 void            put_rect_back (int left, int top, int right,
				int bottom, BYTE *image);
 void            floodfill (int x,int y);
 void            rectangle (int left,int top,int right,int bottom);
 void            rectangle (const RECT& area);
 void            vert_line (int from,int to,int level);
//////////////////////////////////////////////////////////////////////////////

class Display : virtual public MObject {
public:
    ADR            address;
    WORD           length;
    WORD           width;
public:
    Display&       operator= (const Display& dpy);
};

class DC : public MObject{
public:
    VP             vp;
    WORD           color;
    WORD           fill_color;
    Display        dpy;
};

//////////////////////////////////////////////////////////////////////////////

class MGraph : public MObject{
public:
    int                     xpos;
    int                     ypos;
    VP                      vp;
    FONT                    font;
    APLANE *                aplane;
    WORD                    color;
    WORD                    fill_color;
    MPal                    palette;
    BOOL                    IsGraphics;
    WORD                    scr_size;
    Display                 dpy;

public:
			     MGraph (void);
    virtual inline classType isA (void) {return (MGRAPH_ID);};
			    ~MGraph (void);
};
#define GRAPH                MGraph

#ifndef GRAPH_UNIT
extern MGraph gr;
extern BYTE bits[];
#endif
#endif
