
#ifndef __MHASH_H
#define __MHASH_H

typedef WORD		     HKeyType;

class HashEntry {
protected:
    HKeyType         	     Key;
protected:
    virtual void             CreateKey (void) = 0;
public:
			     HashEntry (void) {Key = 0;};
    virtual inline HKeyType  GetHashKey (void) { return (Key);};
    virtual BOOL             operator== (const HashEntry& AnEntry) = 0;
};

class HashTable : public Atom {
public:
			     HashTable (WORD TableSize = MAXWORD);
    virtual void             InsertEntry (HashEntry * NewEntry);
    virtual HashEntry *      RetrieveEntry (HashEntry * JustLikeIt);
    virtual void             DeleteEntry (HashEntry * JustLikeIt);
    virtual void             Resize (WORD NewSize);
			    ~HashTable (void);
};

#endif
