
#ifndef __MLIST_H
#define __MLIST_H

#define LLIST_ID             0x0112

class LLElem {
public:
    LLElem                 * next;
    LLElem                 * prev;
    MObject 		   * data;
public:
			     LLElem (void) { next = NULL; prev = NULL; data = NULL;};
			    ~LLElem (void) {};
};

class LList : public MObject {
protected:
    LLElem                 * Head;
    LLElem                 * Tail;
public:
    WORD 		     CurSize;
    WORD                     MaxSize;
    LLElem                 * Current;
public:
			     LList (WORD TheMaxSize = MAXWORD);
    virtual void             Delete (void);
    void                     End (void);
    void                     End (LLElem * Window);
    virtual BOOL             First (void);
    virtual MObject *        FirstThat (CondFuncType, void * );
    virtual void             ForEach (IterFuncType, void * );
    LLElem *                 GetCurrent (void);
    virtual WORD             GetCurrentOffset (void);
    virtual void             InsertAfter (MObject * elem);
    virtual void             InsertBefore (MObject * elem);
    virtual classType        isA (void);
    virtual inline BOOL      IsEmpty (void) const;
    virtual inline BOOL      IsFull (void) const;
    virtual inline BOOL      Last (void);
    virtual MObject *        LastThat (CondFuncType, void * );
    virtual inline void      MakeCurrent (LLElem * Window);
    virtual void             MoveDown (void);
    virtual void             MoveDown (LLElem * Window);
    virtual void             MoveUp (void);
    virtual void             MoveUp (LLElem * Window);
    virtual MObject *        Remove (void);
    virtual MObject *        Retrieve (void);
    virtual MObject *        Retrieve (LLElem * Window);
    virtual BOOL             OnList (void) const;
    virtual BOOL             OnList (LLElem * Window) const;
    virtual void             printOn (ostream& os);
    virtual void             SetCurrentOffset (WORD NewOffset);
    virtual void             SetCurrentOffset (LLElem * Window, WORD NewOffset);
    void                     Start (void);
    void                     Start (LLElem * Window);
    virtual void             Swap (LLElem * Window);
			    ~LList (void);
};

////////// INLINES ////////////////////////////////////////////////////////////
 inline void LList :: End (void)            { Current = Tail;};
 inline void LList :: End (LLElem * Window) { Window = Tail;};
 inline BOOL LList :: First (void)          { return (Current == Head);};
 inline LLElem * LList :: GetCurrent (void) { return (Current);};
 inline classType LList :: isA (void)       { return (LLIST_ID);};
 inline BOOL LList :: IsEmpty (void) const  { return (Head == NULL);};
 inline BOOL LList :: IsFull (void) const   { return (CurSize >= MaxSize);};
 inline BOOL LList :: Last (void)           { return (Current == Tail);};
 inline void LList :: MakeCurrent (LLElem * Window) { Current = Window;};
 inline void LList :: Start (void)                  { Current = Head;};
 inline void LList :: Start (LLElem * Window)       { Window = Head;};
///////////////////////////////////////////////////////////////////////////////
#endif
