//  Moving object header file.
//  Used for animation
//  Requires   GRAPHICS mode.

#ifndef __MMOB_H
#define __MMOB_H

#define MMOB_ID              0x0114

class MMob : public MObject, public MFileOp {
protected:
    int                      ox;
    int                      oy;
    int                      nx;
    int                      ny;
    int                      PutType;
protected:
    IMAGE *                  image;
    IMAGE *                  backgr;
    IMAGE *                  projection;    // image + backgr
public:
			     MMob (void);
			     MMob (int xpos, int ypos, IMAGE * picture = NULL);
    virtual inline void      RescanBackgr (void);
    virtual void             Show (void);
    virtual inline void      Hide (void) { backgr->Put(nx,ny);};
    virtual inline classType isA (void) {return (MMOB_ID);};
    virtual void             SetImage (const IMAGE& new_image);
    virtual void             SetImage (WORD nlen, WORD nwid, const cArray& arr);
    virtual void             LoadDirect (int fp);
    virtual void             SaveDirect (int fp);
    virtual inline void      SetPut (int new_put);
    virtual void             SetPosition (int xpos,int ypos);
    virtual void             MoveTo (int x,int y);
    inline int               x (void) { return (nx);};
    inline int               y (void) { return (ny);};
			    ~MMob (void);
};
typedef MMob MOB;

#endif
