
#ifndef __MRECT_H
#define __MRECT_H

class IntPoint {
public:
    int                      x;
    int                      y;
public:
                             IntPoint (void);
			     IntPoint (int anX, int aY);
    inline IntPoint&         operator= (const IntPoint& APoint);
};

class SimpleRect : virtual public MObject {
public:
    int                      left;
    int                      top;
    int                      right;
    int                      bottom;

public:
			     SimpleRect (void);
			     SimpleRect (int x1, int y1, int x2, int y2);
    inline void              Set (int x1, int y1, int x2, int y2);
    inline SimpleRect&       operator= (const SimpleRect& ARect);
};

class ViewPort : public SimpleRect {
public:
    int                      length;
    int                      width;

public:
			     ViewPort (void);
			     ViewPort (int x1, int y1, int x2, int y2);
			     ViewPort (const SimpleRect& ARect);
    inline void		     Set (int x1, int y1, int x2, int y2);
    inline SimpleRect&       operator= (const SimpleRect& ARect);
};

#define POINT         IntPoint
#define RECT          SimpleRect
#define VP            ViewPort

#endif
