
#ifndef __MSCROLL_H
#define __MSCROLL_H

#define SCROLLUP             0x0110
#define SCROLLDOWN           0x0111
#define SCROLLRIGHT          0x0112
#define SCROLLLEFT           0x0113
#define SCROLLTO             0x0114

typedef enum {
    Up,
    Down,
    Right,
    Left
} Direction;

class MScroller : public MWindow {
protected:
    VP                       World;
    int                      vxpos;        // Coordinates of the window.
    int                      vypos;
    WORD                     speed;        // Number of pixels to shift by.
    BOOL                     WrapX;
    BOOL                     WrapY;
public:
			     MScroller (int x1, int y1, int x2, int y2,
					WORD AHandle, WORD AnHParent = HROOT);
			     MScroller (const RECT& ABox,
					WORD AHandle, WORD AnHParent = HROOT);
    virtual void             SetWindowPosition (int Newx, int Newy);
    virtual void             ResizeWorld (WORD NewLength, WORD NewWidth);
    virtual void             ResizeWorld (const RECT& NewWorld);
    virtual void             LoadDirect (int fp);
    virtual void             SaveDirect (int fp);
    virtual void             Scroll (Direction where);
    virtual void             SetSpeed (WORD NewSpeed);
			    ~MScroller (void);
};

#endif
