
#ifndef __MWIN_H
#define __MWIN_H

#define MAX_CHILDREN               256

#define NORMAL                  0x0100
#define SHELL_QUIT              0x0101
#define EVENT_NOT_USED          0x0102
#define EVENT_USED              0x0103

#define ADD_CHILD               0x0104
#define REMOVE_CHILD            0x0105

#define DISABLE_WINDOW          0x0106
#define ENABLE_WINDOW           0x0107

#define SET_FOCUS               0x0108
#define REFRESH_WINDOW          0x0109

#define HROOT                        1       // Root window handle

#define MWIN_ID                 0x012A

#define NormalBack                   0
#define NormalFront                  1
#define NormalDarkBorder             2
#define NormalLightBorder            3
#define ActiveBack                   4
#define ActiveFront                  5
#define ActiveDarkBorder             6
#define ActiveLightBorder            7
#define DisabledBack                 8
#define DisabledFront                9
#define DisabledDarkBorder          10
#define DisabledLightBorder         11
#define UserDefined                 12
#define N_COLOR_TYPES                 (UserDefined + 1)

class MWindow : public MTree, public MFileOp {
protected:
    VP                       box;
    WORD                     HParent;
    WORD                     (*UserHandler)(...);
public:
    WORD                     Handle;
    BOOL                     IsActive;
    BOOL                     Disabled;
    BOOL                     Refresh;
    BYTE                     color [N_COLOR_TYPES];
public:
			     MWindow (int x1, int y1, int x2, int y2,
				      WORD AHandle, WORD AnHParent = HROOT);
			     MWindow (const RECT& ABox, WORD AHandle,
				      WORD AnHParent = HROOT);
    virtual void             Draw (void);
    virtual inline void      Activate (void);
    virtual inline void      Deactivate (void);
    virtual inline void      Disable (void);
    virtual inline void      Enable (void);
    virtual WORD             Handler (EVENT event);
    virtual inline classType isA (void) {return MWIN_ID;};
    virtual inline void      LoadDirect (int fp);
    virtual inline void      ResizeBox (WORD NewLength, WORD NewWidth);
    virtual inline void      ResizeBox (const RECT& NewBox);
    virtual inline void      SaveDirect (int fp);
    virtual inline void      SetColor (BYTE what, BYTE extra, BYTE to);
    virtual inline void      SetUserHandler (WORD (*NewUserHandler)(...));
			    ~MWindow (void);
};

#endif
