#include <mio.h>
#include <mgr.h>
#include <mevent.h>
#include <mwin.h>
#include <mlabel.h>
#include <mbutton.h>

//////////////////////// BUTTON control ///////////////////////////////////

/********************************************/
      MButton :: MButton
/********************************************/
(int x1, int y1, int x2, int y2, BYTE ALabel[], WORD AHandle, WORD AParent)
: MLabel (x1, y1, x2, y2, ALabel, AHandle, AParent)
{
BYTE DefaultColors [N_COLOR_TYPES] = {7,0,8,15, 7,0,8,15, 7,8,24,27, 0};

    memcpy (color, DefaultColors, N_COLOR_TYPES);
}

/********************************************/
      MButton :: MButton
/********************************************/
(const RECT& ABox, BYTE ALabel[], WORD AHandle, WORD AParent)
: MLabel (ABox, ALabel, AHandle, AParent)
{
BYTE DefaultColors [N_COLOR_TYPES] = {7,0,8,15, 7,0,8,15, 7,8,24,27, 0};

    memcpy (color, DefaultColors, N_COLOR_TYPES);
}

/********************************************/
 void MButton :: Draw (void)
/********************************************/
{
    if (Refresh)
    {
       mouse.Hide();
       push_DC();
       setviewport (box);

       if (Disabled)
	  setfillstyle (SOLID_FILL, color [DisabledBack]);
       else if (IsActive)
	  setfillstyle (SOLID_FILL, color [ActiveBack]);
       else
	  setfillstyle (SOLID_FILL, color [NormalBack]);

       bar (box);

       if (Disabled)
	  setcolor (color [DisabledDarkBorder]);
       else if (IsActive)
	  setcolor (color [ActiveLightBorder]);
       else
	  setcolor (color [NormalDarkBorder]);

       hor_line (box.left, box.right - 1, box.bottom - 1);
       vert_line (box.top, box.bottom - 1, box.right - 1);

       if (Disabled)
	  setcolor (color [DisabledLightBorder]);
       else if (IsActive)
	  setcolor (color [ActiveDarkBorder]);
       else
	  setcolor (color [NormalLightBorder]);

       hor_line (box.left, box.right - 2, box.top);
       vert_line (box.top, box.bottom - 1, box.left);

       if (Disabled)
	  setcolor (color [DisabledFront]);
       else if (IsActive)
	  setcolor (color [ActiveFront]);
       else
	  setcolor (color [NormalFront]);

       if (IsActive && !Disabled)
	  outtextxy (box.left + 6, box.top + 3, label);
       else
	  outtextxy (box.left + 5, box.top + 2, label);

       pop_DC();
       mouse.RescanBackgr();
       mouse.Show();
    }
}

/********************************************/
 WORD MButton :: Handler
/********************************************/
(EVENT event)
{
WORD status = EVENT_NOT_USED;
    if (event->dest == HNUL || event->dest == Handle)
    {
       if (event->type == DISABLE_WINDOW)
       {
	  Disable();
	  Draw();
       }
       if (event->type == ENABLE_WINDOW)
       {
	  Enable();
	  Draw();
       }
       if ((event->type & MouseMoved) && (IsInside (box, event->xpos, event->ypos)) && !IsActive && !Disabled)
       {
	  Activate();
	  Draw();
	  status = EVENT_USED;
       }
       if ((event->type & MouseMoved) && (!IsInside (box, event->xpos, event->ypos)) && IsActive && !Disabled)
       {
	  Deactivate();
	  Draw();
       }
       if (event->type & ButtonPress && (IsInside (box, event->xpos, event->ypos)) && (!Disabled) && ((void*)UserHandler != NULL))
	  status = UserHandler();
    }
    return (status);
}

/********************************************/
      MButton :: ~MButton (void)
/********************************************/
{
}

///////////////////////////////////////////////////////////////////////////
