#include <mio.h>
#include <mgr.h>
#include <mevent.h>
#include <mwin.h>
#include <mstgrid.h>
#include <mcmap.h>

/*********************************************/
      MCMap :: MCMap
/*********************************************/
(int x1, int y1, int x2, int y2, WORD TheLength,
 WORD TheWidth, WORD AHandle, WORD AnHParent)
: MStGrid (x1,y1, x2,y2, TheLength,TheWidth, AHandle, AnHParent)
{
    Refresh = FALSE;
    push_DC();
}

/*********************************************/
      MCMap :: MCMap
/*********************************************/
(const RECT& ABox, WORD TheLength,
 WORD TheWidth, WORD AHandle, WORD AnHParent)
: MStGrid (ABox, TheLength,TheWidth, AHandle, AnHParent)
{
    Refresh = FALSE;
    push_DC();
}

/********************************************/
 WORD MCMap :: Handler
/********************************************/
(EVENT event)
{
WORD status = EVENT_NOT_USED;
POINT color;

    if (event->dest == HNUL || event->dest == Handle)
    {
       if ((event->type & MouseMoved) && (IsInside (box, event->xpos, event->ypos)) && !IsActive)
       {
	  Activate();
	  status = EVENT_USED;
       }
       if ((event->type & MouseMoved) && (!IsInside (box, event->xpos, event->ypos)) && IsActive)
       {
	  Deactivate();
       }
       if (event->type & ButtonPress && IsInside (box, event->xpos, event->ypos))
       {
	  WhichCell (event->xpos, event->ypos, color);
	  if (event->button & leftButton)
	     setcolor (color.y * Length + color.x);
	  else
	     setfillstyle (SOLID_FILL, color.y * Length + color.x);
          CreateEvent (COLOR_CHANGE, 0, NULL, MAKELONG (gr.color, gr.fill_color), HNUL);
       }
    }
    return (status);
}

/*********************************************/
 void MCMap :: Draw (void)
/*********************************************/
{
int x,y;
    mouse.Hide();
    push_DC();
    setviewport (box);
    for (y = 0; y < Width; ++ y)
       for (x = 0; x < Length; ++ x)
          Draw (x,y);
    pop_DC();
    mouse.RescanBackgr();
    mouse.Show();
}

/*********************************************/
 void MCMap :: Draw
/*********************************************/
(int cx, int cy)
{
    setfillstyle (SOLID_FILL, cy * Length + cx);
    bar (box.left + cx * CellLength, box.top + cy * CellWidth,
	 box.left + (cx + 1) * CellLength, box.top + (cy + 1) * CellWidth);
}

/*********************************************/
      MCMap :: ~MCMap (void)
/*********************************************/
{
    pop_DC();
}
