#include <mio.h>
#include <mgr.h>
#include <mevent.h>
#include <mwin.h>
#include <mlabel.h>

//////////////////////// LABEL control ////////////////////////////////

/********************************************/
      MLabel :: MLabel
/********************************************/
(int x1, int y1, int x2, int y2, BYTE ALabel[], WORD AHandle, WORD AParent)
: MWindow (x1,y1,x2,y2,AHandle,AParent)
{
    if (strlen (ALabel) > 0)
       label = ALabel;
}

/********************************************/
      MLabel :: MLabel
/********************************************/
(const RECT& ABox, BYTE ALabel[], WORD AHandle, WORD AParent)
: MWindow (ABox,AHandle,AParent)
{
    if (strlen (ALabel) > 0)
       label = ALabel;
}

/********************************************/
 void MLabel :: Draw (void)
/********************************************/
{
    if (Refresh)
    {
       mouse.Hide();
       push_DC();
       setviewport (box);
       setcolor (color [NormalFront]);
       outtextxy (box.left, box.top, (BYTE*)label);
       pop_DC();
       mouse.RescanBackgr();
       mouse.Show();
    }
}

/********************************************/
 void MLabel :: LoadDirect
/********************************************/
(int fp)
{
    read (fp, &box, sizeof(RECT));
}

/********************************************/
 void MLabel :: SaveDirect
/********************************************/
(int fp)
{
    write (fp, &box, sizeof(RECT));
}

/********************************************/
 inline void MLabel :: SetLabel
/********************************************/
(BYTE *NewLabel)
{
    if (strlen (NewLabel) > 0)
       label = NewLabel;
}

/********************************************/
      MLabel :: ~MLabel (void)
/********************************************/
{
}

///////////////////////////////////////////////////////////////////////////
