#include <mio.h>
#include <mgr.h>
#include <mevent.h>
#include <mwin.h>
#include <mscroll.h>
#include <mscgrid.h>

////////////////////////////// GRID control /////////////////////////////////

/********************************************/
      MScGrid :: MScGrid
/********************************************/
(int x1, int y1, int x2, int y2, WORD TheLength,
 WORD TheWidth, WORD AHandle, WORD AnHParent)
: MScroller (x1,y1, x2,y2, AHandle, AnHParent)
{
    CellLength = TheLength;
    CellWidth = TheWidth;
    Length = (x2 - x1) / CellLength;
    Width = (y2 - y1) / CellWidth;
}

/********************************************/
      MScGrid :: MScGrid
/********************************************/
(const RECT& ABox, WORD TheLength, WORD TheWidth, 
 WORD AHandle, WORD AnHParent)
: MScroller (ABox, AHandle, AnHParent)
{
    Length = ABox.right - ABox.left;
    Width = ABox.bottom - ABox.top;
    CellLength = TheLength;
    CellWidth = TheWidth;
}

/********************************************/
 void MScGrid :: Scroll
/********************************************/
(Direction where)
{
POINT tlc;
MImage * ScrollBuffer;
int ovx,ovy, x,y;
WORD vlen, vwid;

    ovx = vxpos;
    ovy = vypos;
    MScroller::Scroll (where);

    if (ovx != vxpos || ovy != vypos)
    {
       if (where == Left || where == Right)
	  ScrollBuffer = new MImage (box.length - speed, box.width);
       else
	  ScrollBuffer = new MImage (box.length, box.width - speed);

       TopLeftCell (tlc);
       vlen = GetVisibleLength();
       vwid = GetVisibleWidth();

       mouse.Hide();
       push_DC();
       setviewport (box);

       switch (where) {
	  case Left:   ScrollBuffer->Get (box.left + speed, box.top);
		       ScrollBuffer->Put (box.left, box.top);
		       for (y = 0; y < vwid; ++ y)
			  for (x = vlen - speed / CellLength - 1; x < vlen; ++ x)
			     Draw (tlc.x + x, tlc.y + y);
		       break;
	  case Right:  ScrollBuffer->Get (box.left, box.top);
		       ScrollBuffer->Put (box.left + speed, box.top);
		       for (y = 0; y < vwid; ++ y)
			  for (x = speed / CellLength - 1; x >= 0; -- x)
			     Draw (tlc.x + x, tlc.y + y);
		       break;
	  case Up:     ScrollBuffer->Get (box.left, box.top + speed);
		       ScrollBuffer->Put (box.left, box.top);
		       for (y = vwid - speed / CellWidth - 1; y < vwid; ++ y)
			  for (x = 0; x < vlen; ++ x)
			     Draw (tlc.x + x, tlc.y + y);
		       break;
	  case Down:   ScrollBuffer->Get (box.left, box.top);
		       ScrollBuffer->Put (box.left, box.top + speed);
		       for (y = speed / CellWidth - 1; y >= 0; -- y)
			  for (x = 0; x < vlen; ++ x)
			     Draw (tlc.x + x, tlc.y + y);
		       break;
       }
       pop_DC();
       mouse.RescanBackgr();
       mouse.Show();

       delete ScrollBuffer;
    }
}

/********************************************/
 inline void MScGrid :: TopLeftCell
/********************************************/
(POINT& cell)
{
    cell.x = (int)(vxpos / CellLength);
    cell.y = (int)(vypos / CellWidth);
}

/***********************************************/
 inline WORD MScGrid :: GetVisibleLength (void)
/***********************************************/
{
    return (box.length / CellLength + 1);
}

/***********************************************/
 inline WORD MScGrid :: GetVisibleWidth (void)
/***********************************************/
{
    return (box.width / CellWidth + 1);
}

/********************************************/
 void MScGrid :: SetCellSize
/********************************************/
(WORD length, WORD width)
{
    if (length > 0 && width > 0)
    {
       World.length /= CellLength;
       World.width /= CellWidth;
       vxpos /= CellLength;
       vypos /= CellWidth;
       CellLength = length;
       CellWidth = width;
       World.length *= CellLength;
       World.width *= CellWidth;
       vxpos *= CellLength;
       vypos *= CellWidth;
       SetWindowPosition (vxpos, vypos);
    }
}

/********************************************/
 inline void MScGrid :: WhichCell
/********************************************/
(int x, int y, POINT& cell)
{
    cell.x = (int)((x + vxpos) / CellLength);
    cell.y = (int)((y + vypos) / CellWidth);
}

/********************************************/
 void MScGrid :: LoadDirect
/********************************************/
(int fp)
{
    read (fp, &box, sizeof(RECT));
}

/********************************************/
 void MScGrid :: SaveDirect
/********************************************/
(int fp)
{
    write (fp, &box, sizeof(RECT));
}

/********************************************/
      MScGrid :: ~MScGrid (void)
/********************************************/
{
}

//////////////////////////////////////////////////////////////////////////////
