#include <mio.h>
#include <mgr.h>
#include <mevent.h>
#include <mwin.h>
#include <mstgrid.h>

////////////////////////////// STGRID control ///////////////////////////////

/********************************************/
      MStGrid :: MStGrid
/********************************************/
(int x1, int y1, int x2, int y2, WORD TheLength,
 WORD TheWidth, WORD AHandle, WORD AnHParent)
: MWindow (x1,y1, x2,y2, AHandle, AnHParent)
{
    CellLength = TheLength;
    CellWidth = TheWidth;
    Length = (x2 - x1) / CellLength;
    Width = (y2 - y1) / CellWidth;
}

/********************************************/
      MStGrid :: MStGrid
/********************************************/
(const RECT& ABox, WORD TheLength, WORD TheWidth,
 WORD AHandle, WORD AnHParent)
: MWindow (ABox, AHandle, AnHParent)
{
    CellLength = TheLength;
    CellWidth = TheWidth;
    Length = (ABox.right - ABox.left) /CellWidth;
    Width = (ABox.bottom - ABox.top) / CellWidth;
}

/********************************************/
 inline void MStGrid :: WhichCell
/********************************************/
(int x, int y, POINT& cell)
{
    cell.x = (int)((x - box.left) / CellLength);
    cell.y = (int)((y - box.top) / CellWidth);
}

/********************************************/
 void MStGrid :: LoadDirect
/********************************************/
(int fp)
{
    read (fp, &box, sizeof(RECT));
}

/********************************************/
 void MStGrid :: SaveDirect
/********************************************/
(int fp)
{
    write (fp, &box, sizeof(RECT));
}

/********************************************/
 void MStGrid :: SetCellSize
/********************************************/
(WORD length, WORD width)
{
    if (length > 0 && width > 0)
    {
       CellLength = length;
       CellWidth = width;
       Length = box.length / CellLength;
       Width = box.length / CellWidth;
    }
}

/********************************************/
      MStGrid :: ~MStGrid (void)
/********************************************/
{
}

//////////////////////////////////////////////////////////////////////////////
