#pragma inline
#include <mstd.h>
#include <mobject.h>
#include <mfileop.h>
#include <mmem.h>
#include <mpal.h>

static BYTE FadeBuffer [MAXCOL * 3];
static BYTE StandartPalette [MAXCOL * 3];

/*********************************************/
      MPal :: MPal (void)
/*********************************************/
: Atom (MAXCOL, 3)
{
    Update();
}

/*********************************************/
 void MPal :: SetRGB
/*********************************************/
(int ncol,int red,int green,int blue)
{
BYTE *curmap = NULL;
    curmap = (BYTE*)mem;
    curmap [ncol*3] = red;
    curmap [ncol*3+1] = green;
    curmap [ncol*3+2] = blue;
asm MOV AH,0x10
asm MOV AL,0x10
asm MOV BX,ncol
asm MOV CH,green
asm MOV CL,blue
asm MOV DH,red
asm INT 0x10
}

/*********************************************/
 void MPal :: SetAll
/*********************************************/
(BYTE *new_palette)
{
    memmove (mem, new_palette, MAXCOL * 3);
asm PUSH ES
    _DX = FP_OFF (mem);
    _ES = FP_SEG (mem);
asm MOV BX, 0
asm MOV AX, 1012h
asm MOV CX, 0xFF
asm INT 0x10
asm POP ES
}

/********************************************/
 void MPal :: FadeOut (void)
/********************************************/
{
int lev, col, beam;
BYTE *curmap;

    memcpy (FadeBuffer, mem, size);
    for (lev = 0; lev < 65; ++ lev)
    {
       curmap = (BYTE*) mem;
       for (col = 0; col < MAXCOL; ++ col)
       {
	  for (beam = 0; beam < 3; ++ beam)
	     if (curmap[beam] > 0)
		curmap[beam] -= 1;
	  curmap += 3;
       }
       SetAll ((BYTE*)mem);
    }
}

/********************************************/
 void MPal :: FadeIn (void)
/********************************************/
{
int lev, col, beam;
BYTE *curmap;
BYTE *bufmap;

    for (lev = 0; lev < 65; ++ lev)
    {
       curmap = (BYTE*) mem;
       bufmap = FadeBuffer;
       for (col = 0; col < MAXCOL; ++ col)
       {
	  for (beam = 0; beam < 3; ++ beam)
	     if (curmap[beam] < bufmap[beam])
		++ curmap[beam];
	  curmap += 3;
	  bufmap += 3;
       }
       SetAll ((BYTE*) mem);
    }
}

/********************************************/
 void MPal :: RotateLeft
/********************************************/
(BYTE Start, BYTE End)
{
BYTE TempBuf[3];
    memcpy (TempBuf, (BYTE*)mem + Start * 3, 3);
    memcpy ((BYTE*)mem + 3, (BYTE*)mem, (End - Start - 1) * 3);
    memcpy ((BYTE*)mem + End * 3, TempBuf, 3);
    SetAll ((BYTE*)mem);
}

/********************************************/
 void MPal :: RotateRight
/********************************************/
(BYTE Start, BYTE End)
{
BYTE TempBuf[3];
    memcpy (TempBuf, (BYTE*)mem + End * 3, 3);
    memcpy ((BYTE*)mem, (BYTE*)mem + 3, (End - Start - 1) * 3);
    memcpy ((BYTE*)mem + Start * 3, TempBuf, 3);
    SetAll ((BYTE*)mem);
}

/********************************************/
 void MPal :: Reset (void)
/********************************************/
{
    SetAll (StandartPalette);
}

/********************************************/
 void MPal :: Update (void)
/********************************************/
{
asm PUSH ES
    _DX = FP_OFF (mem);
    _ES = FP_SEG (mem);
asm MOV AX, 0x1017
asm MOV BX, 0
asm MOV CX, 0xFF
asm INT 0x10
asm POP ES

    memcpy (StandartPalette, mem, size);
}

/********************************************/
      MPal :: ~MPal (void)
/********************************************/
{
}
