#include <mstd.h>
#include <mobject.h>
#include <mrect.h>
#include <mfileop.h>
#include <mmem.h>
#include <mtypes.h>
#include <marray.h>
#include <mgraph.h>
#include <mimages.h>
#include <mmob.h>
#include <manimob.h>

////////////////////////// AnimLoop class ////////////////////////////////////

/********************************************/
      AnimLoop :: AnimLoop (void)
/********************************************/
{
}

/********************************************/
 inline void AnimLoop :: Advance (void)
/********************************************/
{
    Images.MoveDown();
}

/********************************************/
 void AnimLoop :: LoadDirect
/********************************************/
(int fp)
{
MImage *NewRead;
WORD n, nImages;
    read (fp, &nImages, sizeof(WORD));
    Images.Start();
    for (n = 0; n < nImages; ++ n)
    {
       NewRead = new MImage;
       NewRead->LoadDirect (fp);
       Images.InsertAfter (NewRead);
    }
}

/********************************************/
 void AnimLoop :: SaveDirect
/********************************************/
(int fp)
{
WORD n;
MImage *ptr;

    write (fp, &Images.CurSize, sizeof(WORD));
    Images.Start();
    for (n = 0; n < Images.CurSize; ++ n)
    {
       ptr = (MImage*) Images.Retrieve();
       ptr->SaveDirect (fp);
       Images.MoveDown();
    }
}

//////////////////////////// AniMob class ////////////////////////////////////

/********************************************/
      AniMob :: AniMob (void)
/********************************************/
{
    Master = NULL;
}

/********************************************/
      AniMob :: AniMob
/********************************************/
(int xpos, int ypos)
: MMob (xpos, ypos)
{
    Master = NULL;
}

/********************************************/
 inline void AniMob :: Advance (void)
/********************************************/
{
AnimLoop * CurLoop;
    CurLoop = (AnimLoop*) Loops.Retrieve();
    CurLoop->Images.MoveDown();
    image = (MImage*) CurLoop->Images.Retrieve();
}

/********************************************/
 void AniMob :: SetLoop
/********************************************/
(WORD NewLoop)
{
AnimLoop * CurLoop;
    Loops.SetCurrentOffset (NewLoop);
    CurLoop = (AnimLoop*) Loops.Retrieve();
    CurLoop->Images.Start();
    image = (MImage*) CurLoop->Images.Retrieve();
}

#pragma argsused
/********************************************/
 void AniMob :: Connect
/********************************************/
(AniMob * AMaster)
{
}

/********************************************/
 void AniMob :: LoadDirect
/********************************************/
(int fp)
{
AnimLoop *NewRead;
WORD n, nLoops;
    read (fp, &nLoops, sizeof(WORD));
    Loops.Start();
    for (n = 0; n < nLoops; ++ n)
    {
       NewRead = new AnimLoop;
       NewRead->LoadDirect (fp);
       Loops.InsertAfter (NewRead);
    }
}

/********************************************/
 void AniMob :: SaveDirect
/********************************************/
(int fp)
{
WORD n;
AnimLoop * CurLoop;
    write (fp, &Loops.CurSize, sizeof(WORD));
    Loops.Start();
    for (n = 0; n < Loops.CurSize; ++ n)
    {
       CurLoop = (AnimLoop*) Loops.Retrieve();
       CurLoop->SaveDirect (fp);
       Loops.MoveDown();
    }
}

/********************************************/
      AniMob :: ~AniMob (void)
/********************************************/
{
}

//////////////////////////////////////////////////////////////////////////////
