#include <mstd.h>
#include <mobject.h>
#include <mrect.h>
#include <mfileop.h>
#include <mmem.h>
#include <marray.h>
#include <mkey.h>
#include <mlist.h>
#include <mstaque.h>
#include <mgraph.h>
#include <mgerr.h>
#include <mimages.h>

RECT ErrorBox (MAXX/6, MAXY/2 - 20, MAXX - MAXX/6, MAXY/2 + 20);

/********************************************/
 void            PrintError
/********************************************/
(char * message, BOOL DoExit)
{
IMAGE back (ErrorBox.right - ErrorBox.left + 6, 
	    ErrorBox.bottom - ErrorBox.top + 6);

    if (gr.IsGraphics)
    {
       if (!DoExit)
       {
          push_DC();
          back.Get (ErrorBox.left, ErrorBox.top);
       }
       setfillstyle (SOLID_FILL, 0);
       setcolor (0);
       bar (ErrorBox.left + 5, ErrorBox.top + 5, ErrorBox.right + 5, ErrorBox.bottom + 5);
       setfillstyle (SOLID_FILL, 4);
       setcolor (14);
       bar (ErrorBox);
       rectangle (ErrorBox);
       outtextxy (ErrorBox.left + 50, ErrorBox.top + 5, "ERROR");
       setcolor (15);
       outtextxy (ErrorBox.left + 10, ErrorBox.top + 20, message);
       setcolor (11);
       if (DoExit)
	  outtextxy (ErrorBox.left + 50, ErrorBox.bottom - 10, "Press a key to exit...");
    }
    else
    {
       cerr << "ERROR : " << message << "\n";
       if (DoExit)
	  cerr << "Press any key to exit...";
    }
    while (kbhit()) getch();
    while (!kbhit());
    if (DoExit)
       exit(1);
    else if (gr.IsGraphics && !DoExit)
    {
       back.Put (ErrorBox.left, ErrorBox.top);
       pop_DC();
    }
}
