#include <values.h>
#include <mstd.h>
#include <mobject.h>
#include <mrect.h>
#include <mfileop.h>
#include <mmem.h>
#include "mmulle.h"
#include <merror.h>

/*********************************************/
     multifile :: multifile (void)
/*********************************************/
{
    files = (P_FILE*) AllocMem (sizeof(P_FILE));
}

/*********************************************/
     multifile :: multifile
/*********************************************/
(BYTE name[13])
{
    files = (P_FILE*) AllocMem (sizeof(P_FILE));
    SetMainFile (name);
}

/*********************************************/
 void multifile :: SetMainFile
/*********************************************/
(BYTE name[13])
{
int fp;
BYTE str [MULLE_HEADER_LENGTH + 1];
    strncpy (filename, name, 13);
    fp = open (filename, O_RDONLY | O_BINARY);
    if (fp >= 0)
    {
       read (fp, str, 9);
       if (strncmp (str, MULLE_HEADER, MULLE_HEADER_LENGTH) != 0)
	  PrintTextError ("Invalid mulle file!");
       close (fp);
    }
    else
       PrintTextError ("Could not open mulle file!");

    ReadMainFile();
}

/*********************************************/
 void multifile :: ReadMainFile (void)
/*********************************************/
{
int fp;
BYTE header[10];  // Every multifile starts with HEADER.
int n;
    fp = open (filename, O_RDONLY | O_BINARY);
    read (fp, header, MULLE_HEADER_LENGTH);
    read (fp, &nFiles, sizeof(WORD));
    files = (P_FILE*) ReallocMem (files, nFiles * sizeof(P_FILE));
    for (n = 0; n < nFiles; ++ n)
       read (fp, &files[n], sizeof(P_FILE));
    headLen = tell (fp);
    close (fp);
}

/********************************************/
 DWORD multifile :: GetOffset
/********************************************/
(BYTE name[13])
{
int n;
    for (n = 0; n < nFiles; ++ n)
    {
       if (strcmp (name, files[n].name) == 0)     // If file is found
	  return (files[n].offset + headLen);
    }
    PrintTextError ("Attempt to read unexisting file in mulle!");
    return (0L);
}

/********************************************/
 void multifile :: ReadData
/********************************************/
(BYTE name[13], ATOM& buffer)
{
int id = -1, n = 0;
    do
    {
       if (strcmp (name, files[n].name) == 0)     // If file is found
       {
	  id = n;
	  n = nFiles;                              // Finish the loop
       }
       else
	  ++ n;
    }
    while (n < nFiles);

    if (n < nFiles)
    {
       buffer.Resize (files[id].size);
       buffer.Load (filename, files[id].offset);
    }
}

/********************************************/
 void * multifile :: ReadData
/********************************************/
(BYTE name[13])
{
int id = -1, n = 0;
void *buffer;
int fp;

    do
    {
       if (strcmp (name, files[n].name) == 0)     // If file is found
       {
	  id = n;
	  n = nFiles;                              // Finish the loop
       }
       else
	  ++ n;
    }
    while (n < nFiles);

    if (n < nFiles)
    {
       buffer = AllocMem (files[id].size);
       if ((fp = open (filename, O_RDONLY | O_BINARY)) >= 0)
       {
	  lseek (fp, files[id].offset, SEEK_SET);
	  read (fp, (BYTE*)buffer, files[id].size);
	  close (fp);
       }
       else
	  PrintTextError ("Could not open multifile!");
    }
    return (buffer);
}

/********************************************/
      multifile :: ~multifile (void)
/********************************************/
{
    FreeMem (files);
}

