////////////////////////////////////////////////////////////////////////////////
// FILE: MFILEOP
// 	An abstract class that provides generic file operations.
////////////////////////////////////////////////////////////////////////////////

#include <sys\stat.h>
#include <mstd.h>
#include <mfileop.h>
#include <merror.h>

/********************************************/
 void MFileOp :: Load
/********************************************/
(char * filename, DWORD offset)
{
int fp;
    if ((fp = open (filename, O_RDONLY | O_BINARY)) >= 0)
    {
       lseek (fp, offset, SEEK_SET);
       LoadDirect (fp);
       close (fp);
    }
    else
       perror ("Load error");
}

/********************************************/
 void MFileOp :: Save
/********************************************/
(char * filename, DWORD offset)
{
int fp;
int options = O_BINARY | O_WRONLY;

    if (access (filename, 0) != 0)
       options = options | O_CREAT | O_TRUNC;

    if ((fp = open (filename, options, S_IREAD | S_IWRITE)) >= 0)
    {
       lseek (fp, offset, SEEK_SET);
       SaveDirect (fp);
       close (fp);
    }
    else
       perror ("Save error");
}

