////////////////////////////////////////////////////////////////////////////////
// FILE: MMEM
//    Memory operations. Features NULL-proof memory allocation and fast       
// memory copy from one pointer to the other with optional spread.            
////////////////////////////////////////////////////////////////////////////////

#include <values.h>
#include <mem.h>
#include <io.h>
#include <mstd.h>
#include <mobject.h>
#include <mfileop.h>
#include <mmem.h>
#include <merror.h>

////////////////////////////// Atom class ///////////////////////////////////

/********************************************/
     Atom :: Atom (void)
/********************************************/
{
    size = 0;              // Empty array
    elSize = 1;            // Size of one BYTE
    nElem = 0;
    mem = NULL;
}

/********************************************/
     Atom :: Atom
/********************************************/
(WORD n_elem, SIZE n_elSize)
{
    elSize = n_elSize;
    nElem = n_elem;
    size = elSize * nElem;
    mem = AllocMem (size);
    Clear();
}

/********************************************/
     Atom :: Atom
/********************************************/
(const Atom& atom)
{
    elSize = atom.elSize;
    nElem = atom.nElem;
    size = atom.size;
    mem = AllocMem (size);
    MoveMem (atom.mem, mem, size);
}

/********************************************/
 inline WORD Atom :: GetMaxElem (void)
/********************************************/
{
    return (nElem);
}

/********************************************/
 void Atom :: Resize
/********************************************/
(WORD n_nelem, SIZE n_elSize)
{
SIZE OldSize;
    OldSize = size;
    nElem = n_nelem;
    if (n_elSize > 0)
       elSize = n_elSize;
    else
       elSize = 1;
    size = elSize * nElem;
    mem = ReallocMem (mem, size);
    if (size > OldSize)
       memset ((BYTE*)mem + OldSize, 0x00, size - OldSize);
}

/********************************************/
 inline void Atom :: Clear (void)
/********************************************/
{
    memset (mem, 0x00, size);
}

/********************************************/
 inline void Atom :: Move
/********************************************/
(WAY Way, WORD Offset, PTR Where, SIZE HowMuch)
{
    if (Way == PutOn)
       MoveMem ((char*)mem + Offset, Where, min (HowMuch, size));
    else
       MoveMem (Where, (char*)mem + Offset, min (HowMuch, size));
}

/********************************************/
 inline void Atom :: Move
/********************************************/
(WAY Way, WORD Offset, PTR Where, WORD HowMany, SIZE OfHowMuch, WORD Skip, WORD Ignore)
{
    if (Way == PutOn)
       MoveMem ((char*)mem + Offset, Where, HowMany, min (OfHowMuch, size), Skip, Ignore);
    else
       MoveMem (Where, (char*)mem + Offset, HowMany, min (OfHowMuch, size), Skip, Ignore);
}

/********************************************/
 void  Atom :: Fill
/********************************************/
(void *sample)
{
int n;
    if (elSize > 1)
    {
       for (n = 0; n < nElem; ++ n)
	  MoveMem (sample, (BYTE*)mem + n, (WORD)elSize);
    }
    else
       memset (mem, *(int*)sample, size);
}

/********************************************/
 void Atom :: SaveDirect
/********************************************/
(int fp)
{
    write (fp, mem, size);
}

/********************************************/
 void Atom :: LoadDirect
/********************************************/
(int fp)
{
DWORD flen;
    flen = filelength (fp);
    read (fp, mem, min (size, flen));
}

/********************************************/
 Atom& Atom :: operator+
/********************************************/
(const Atom& a1)
{
Atom *a2 = NULL;
    if (a1.elSize == elSize)
    {
       a2 = new Atom (a1.nElem + nElem, elSize);
       MoveMem (mem, a2->mem, size);
       MoveMem (a1.mem, (BYTE*)a2->mem + size, a1.size);
       return (*a2);
    }
    return (*this);
}

/********************************************/
 Atom&  Atom :: operator=
/********************************************/
(const Atom& atom)
{
    if (this != &atom)
    {
       Resize (atom.nElem, atom.elSize);
       Move (GetFrom, 0, atom.mem, size);
    }
    return (*this);
}

/********************************************/
 PTR Atom :: operator[]
/********************************************/
(DWORD index)
{
    if (index < nElem)
       return ((ADR)(mem) + index * elSize);
    else
       return (NULL);
}

/********************************************/
	Atom :: operator void*() const
/********************************************/
{
    return (mem);
}

/********************************************/
	Atom :: operator BYTE*() const
/********************************************/
{
    return ((BYTE*)mem);
}

/********************************************/
 void * Atom :: FirstThat
/********************************************/
(CondFuncType test, void * param)
{
int n;
BYTE * ptr = (BYTE*) mem;
    for (n = 0; n < nElem; ++ n)
    {
       if (test ((MObject*) ptr, param) == TRUE)
	  break;
       ptr += elSize / sizeof(BYTE);
    }

    if (n < nElem)
       return (ptr);
    else
       return (NULL);
}

/********************************************/
 void * Atom :: LastThat
/********************************************/
(CondFuncType test, void * param)
{
int n;
BYTE * ptr = (BYTE*) mem;
    for (n = nElem - 1; n >= 0; -- n)
    {
       if (test ((MObject*) ptr, param) == TRUE)
	  break;
       ptr += elSize / sizeof(BYTE);
    }

    if (n < 0)
       return (ptr);
    else
       return (NULL);
}

/********************************************/
 void Atom :: ForEach
/********************************************/
(IterFuncType func, void * param)
{
WORD pos;
BYTE * ptr = (BYTE*) mem;
    for (pos = 0; pos < nElem; ++ pos)
    {
       func ((MObject*) ptr, param);
       ptr += elSize / sizeof(BYTE);
    }
}

/********************************************/
	Atom :: ~Atom (void)
/********************************************/
{
    FreeMem (mem);
}

///////////////////////////// End Atom class ////////////////////////////////
