#include <mstd.h>
#include <mobject.h>
#include <mlist.h>
#include <mclist.h>

//////////////////////////// Linked list class ///////////////////////////////

/********************************************/
      LCList :: LCList
/********************************************/
(WORD TheMaxSize)
: LList (TheMaxSize)
{
}

/********************************************/
 WORD LCList :: GetCurrentOffset (void)
/********************************************/
{
LLElem * OneToFind;
WORD pos = 0;
    OneToFind = Current;
    Start();
    while (OneToFind != Current)
    {
       MoveDown();
       if (First()) break;    // Quit if made a full circle.
       ++ pos;
    }
    Current = OneToFind;
    return ((pos < CurSize) ? (pos) : (0));
}

/********************************************/
 void LCList :: InsertBefore
/********************************************/
(MObject * elem)
{
LLElem * base;
    if (elem != NULL && !IsFull() && (OnList() || IsEmpty()))
    {
       base = new LLElem;
       base->data = elem;

       if (Current != NULL)          // If the list is not empty
       {
	  base->next = Current;
	  base->prev = Current->prev;
	  Current->prev = base;
       }
       if (Tail == NULL)
	  Tail = base;
       if (Head == Current)
	  Head = base;
       if (Tail == base)
	  base->next = Head;
       if (Head == base)
	  base->prev = Tail;
       Current = base;               // Make the new element current
       ++ CurSize;
    }
    else
    {
       if (elem != NULL)
          delete elem;
    }
}

/********************************************/
 void LCList :: InsertAfter
/********************************************/
(MObject * elem)
{
LLElem * base;
    if (elem != NULL && !IsFull() && (OnList() || IsEmpty()))
    {
       base = new LLElem;
       base->data = elem;

       if (Current != NULL)          // If the list is not empty
       {
	  base->next = Current->next;
	  base->prev = Current;
	  Current->next = base;
       }
       if (Tail == Current)
	  Tail = base;
       if (Head == NULL)
	  Head = base;
       if (Tail == base)
	  base->next = Head;
       if (Head == base)
	  base->prev = Tail;
       Current = base;               // Make the new element current
       ++ CurSize;
    }
    else
    {
       if (elem != NULL)
          delete elem;
    }
}

/********************************************/
 MObject * LList :: Retrieve (void)
/********************************************/
{
    if (OnList())
       return (Current->data);
    else
       return (NULL);
}

/********************************************/
 MObject * LList :: Retrieve
/********************************************/
(LLElem * Window)
{
    if (OnList (Window))
       return (Window->data);
    else
       return (NULL);
}

/********************************************/
 void LCList :: ForEach
/********************************************/
(IterFuncType func, void * data)
{
    if (!IsEmpty())
    {
       Start();
       do
       {
	  func (Current->data, data);
	  MoveDown();
       }
       while (!First());
    }
}

/********************************************/
 MObject * LCList :: FirstThat
/********************************************/
(CondFuncType func, void * data)
{
MObject * temp = NULL;
    if (!IsEmpty())
    {
       Start();
       do
       {
	  if (func (Current->data, data) == TRUE)
	     temp = Current->data;
	  MoveDown();
       }
       while (!First() && temp == NULL);
    }
    return (temp);
}

/********************************************/
 MObject * LCList :: LastThat
/********************************************/
(CondFuncType func, void * data)
{
MObject * temp = NULL;
    if (!IsEmpty())
    {
       End();
       do
       {
	  if (func (Current->data, data) == TRUE)
	     temp = Current->data;
	  MoveUp();
       }
       while (!Last() && temp == NULL);
    }
    return (temp);
}

/********************************************/
 void LCList :: printOn
/********************************************/
(ostream& os)
{
LLElem * oldCurrent;
    if (!IsEmpty())
    {
       oldCurrent = GetCurrent();
       Start();
       do
       {
	  os << Current->data;
	  MoveDown();
       }
       while (!First());
       MakeCurrent (oldCurrent);
    }
}

/********************************************/
      LCList :: ~LCList (void)
/********************************************/
{
}
