#include <mstd.h>
#include <mobject.h>
#include <mcomplex.h>

//////////////////////////// Complex number class ////////////////////////////

/********************************************/
      Complex :: Complex (void)
/********************************************/
{
    real = 0;
    imag = 0;
}

/********************************************/
      Complex :: Complex
/********************************************/
(float Real, float Imag)
{
    real = Real;
    imag = Imag;
}

/********************************************/
 Complex& Complex :: operator=
/********************************************/
(const Complex& number)
{
    real = number.real;
    imag = number.imag;
    return (*this);
}

/********************************************/
 Complex& Complex :: operator=
/********************************************/
(const FPOINT& number)
{
    real = number.x;
    imag = number.y;
    return (*this);
}

/********************************************/
 Complex& Complex :: operator+
/********************************************/
(const Complex& number)
{
Complex *c;
    c = new Complex (real + number.real, imag + number.imag);
    return (*c);
}

/********************************************/
 Complex& Complex :: operator-
/********************************************/
(const Complex& number)
{
Complex *c;
    c = new Complex (real - number.real, imag - number.imag);
    return (*c);
}

/********************************************/
 Complex&        operator+
/********************************************/
(const Complex& num1, const Complex& num2)
{
Complex *c;
    c = new Complex (num1.real + num2.real, num1.imag + num2.imag);
    return (*c);
}

/********************************************/
 Complex& Complex :: operator*
/********************************************/
(const Complex& number)
{
Complex *c;
    c = new Complex;
    c->real = real * number.real - imag * number.imag;
    c->imag = imag * number.real + real * number.imag;
    return (*c);
}

/********************************************/
 Complex& Complex :: operator*
/********************************************/
(float number)
{
Complex *c;
    c = new Complex (real * number, imag * number);
    return (*c);
}

/********************************************/
 Complex& Complex :: operator/
/********************************************/
(const Complex& number)
{
Complex *c;
float denom;
    c = new Complex;
    denom = number.real * number.real + number.imag * number.imag;
    c->real = (real * number.real + imag * number.imag) / denom;
    c->imag = (imag * number.real - real * number.imag) / denom;
    return (*c);
}

/********************************************/
 float Complex :: Magnitude (void)
/********************************************/
{
    return (sqrt (real * real + imag * imag));
}

/********************************************/
 void Complex :: Normalize (void)
/********************************************/
{
float mag;
    mag = Magnitude();
    real = real / mag;
    imag = imag / mag;
}

/********************************************/
 Complex&          cos
/********************************************/
(Complex& num)
{
    num.real = cos (num.real) * cosh (num.imag);
    num.imag = (-1) * sin (num.real) * sinh (num.imag);
    return (num);
}

/********************************************/
 Complex&           sin
/********************************************/
(Complex& num)
{
    num.real = sin (num.real) * cosh (num.imag);
    num.imag = cos (num.real) * sinh (num.imag);
    return (num);
}

/********************************************/
      Complex :: ~Complex (void)
/********************************************/
{
}

