#include <mio.h>
#include <mtypes.h>

/********************************************/
      HashTable :: HashTable
/********************************************/
(WORD TableSize)
: Atom (TableSize, sizeof(HashEntry*))
{
}

/********************************************/
 void HashTable :: InsertEntry
/********************************************/
(HashEntry * NewEntry)
{
WORD pos, RoundRobin = 0;
HashEntry ** Entries = (HashEntry**) mem;

    pos = NewEntry->GetHashKey();
    pos = pos % size;

    while (Entries[pos] != NULL && RoundRobin < nElem)
    {
       ++ RoundRobin;
       pos = (pos + 1) % nElem;
    }

    if (RoundRobin == nElem)
       PrintTextError ("Hash table is full");

    Entries[pos] = NewEntry;
}

/********************************************/
 HashEntry * HashTable :: RetrieveEntry
/********************************************/
(HashEntry * JustLikeIt)
{
WORD pos, key, RoundRobin = 0;
HashEntry * result = NULL;
HashEntry ** Entries = (HashEntry**) mem;

    pos = key = JustLikeIt->GetHashKey();
    pos = pos % nElem;

    while (Entries[pos] != NULL && RoundRobin < nElem)
    {
       if (Entries[pos]->GetHashKey() == key && *Entries[pos] == *JustLikeIt)
       {
	  result = Entries[pos];
	  break;
       }
       ++ RoundRobin;
       pos = (pos + 1) % nElem;
    }
    if (RoundRobin == nElem)
       PrintTextError ("Hash table is full!");

    return (result);
}

/********************************************/
 void HashTable :: DeleteEntry
/********************************************/
(HashEntry * JustLikeIt)
{
WORD pos, RoundRobin = 0;
HashEntry ** Entries = (HashEntry**) mem;

    pos = JustLikeIt->GetHashKey() % nElem;

    while (Entries[pos] != NULL && RoundRobin < nElem)
    {
       if (Entries[pos]->GetHashKey() == JustLikeIt->GetHashKey() &&
           *Entries[pos] == *JustLikeIt)
       {
	  delete Entries[pos];
          Entries[pos] = NULL;
       }
       ++ RoundRobin;
       pos = (pos + 1) % nElem;
    }
    if (RoundRobin == nElem)
       PrintTextError ("Hash table is full!");
}

/********************************************/
 void HashTable :: Resize
/********************************************/
(WORD NewSize)
{
    Atom :: Resize (NewSize, sizeof(HashEntry*));
}

/********************************************/
      HashTable :: ~HashTable (void)
/********************************************/
{
int n;
HashEntry ** Entries = (HashEntry**) mem;
    for (n = 0; n < nElem; ++ n)
       if (Entries[n] != NULL)
	  delete Entries[n];
}
