#include <mstd.h>
#include <mobject.h>
#include <mlist.h>

//////////////////////////// Linked list class ///////////////////////////////

/********************************************/
      LList :: LList
/********************************************/
(WORD TheMaxSize)
{
    Head = Tail = Current = NULL;
    MaxSize = TheMaxSize;
    CurSize = 0;
}

/********************************************/
 void LList :: MoveUp (void)
/********************************************/
{
    if (Current != NULL)
       Current = Current->prev;
}

/********************************************/
 void LList :: MoveUp
/********************************************/
(LLElem * Window)
{
    if (Window != NULL)
       Window = Window->prev;
}

/********************************************/
 void LList :: MoveDown (void)
/********************************************/
{
    if (Current != NULL)
       Current = Current->next;
}

/********************************************/
 void LList :: MoveDown
/********************************************/
(LLElem * Window)
{
    if (Window != NULL)
       Window = Window->next;
}

/********************************************/
 void LList :: SetCurrentOffset
/********************************************/
(WORD NewOffset)
{
    Start();
    for (; NewOffset > 0 && OnList(); --NewOffset)
       MoveDown();
}

/********************************************/
 void LList :: SetCurrentOffset
/********************************************/
(LLElem * Window, WORD NewOffset)
{
    Start (Window);
    for (; NewOffset > 0 && OnList (Window); --NewOffset)
       MoveDown (Window);
}

/********************************************/
 WORD LList :: GetCurrentOffset (void)
/********************************************/
{
LLElem * OneToFind;
WORD pos = 0;
    OneToFind = Current;
    Start();
    while (!OnList() && OneToFind != Current)
    {
       MoveDown();
       ++ pos;
    }
    Current = OneToFind;
    return ((pos < CurSize) ? (pos) : (0));
}

/********************************************/
 void LList :: Swap
/********************************************/
(LLElem * Window)
{
LLElem * temp;
    if (Window != NULL && Current != NULL)
    {
       temp = Window->next;
       Window->next = Current->next;
       Current->next = temp;
       temp = Window->prev;
       Window->prev = Current->prev;
       Current->prev = temp;
       MakeCurrent (Window);
    }
}

/********************************************/
 void LList :: InsertBefore
/********************************************/
(MObject * elem)
{
LLElem * base;
    if (elem != NULL && !IsFull() && (OnList() || IsEmpty()))
    {
       base = new LLElem;
       base->data = elem;

       if (Current != NULL)          // If the list is not empty
       {
	  base->next = Current;
	  base->prev = Current->prev;
	  Current->prev = base;
       }
       if (Tail == NULL)
	  Tail = base;
       if (Head == Current)
	  Head = base;
       Current = base;               // Make the new element current
       ++ CurSize;
    }
    else
    {
       if (elem != NULL)
          delete elem;
    }
}

/********************************************/
 void LList :: InsertAfter
/********************************************/
(MObject * elem)
{
LLElem * base;
    if (elem != NULL && !IsFull() && (OnList() || IsEmpty()))
    {
       base = new LLElem;
       base->data = elem;

       if (Current != NULL)          // If the list is not empty
       {
	  base->next = Current->next;
	  base->prev = Current;
	  Current->next = base;
       }
       if (Tail == Current)
	  Tail = base;
       if (Head == NULL)
	  Head = base;
       Current = base;               // Make the new element current
       ++ CurSize;
    }
    else
    {
       if (elem != NULL)
          delete elem;
    }
}

/********************************************/
 MObject * LList :: Remove (void)
/********************************************/
{
MObject * found = NULL;
LLElem * temp;
    if (OnList())
    {
       found = Current->data;

       if (Head == Current)
	  Head = Current->next;    // If removing head
       else
	  Current->prev->next = Current->next;

       if (Tail == Current)
	  Tail = Current->prev;    // If removing tail
       else
	  Current->next->prev = Current->prev;

       temp = Current;

       if (Current->next == NULL)
	  Current = Current->prev;
       else
	  Current = Current->next;

       delete temp;

       -- CurSize;
    }
    return (found);
}

/********************************************/
 inline void LList :: Delete (void)
/********************************************/
{
MObject * temp;
    temp = Remove();
    delete temp;
}

/********************************************/
 inline BOOL LList :: OnList (void) const
/********************************************/
{
    return (Current != NULL);
}

/********************************************/
 inline BOOL LList :: OnList
/********************************************/
(LLElem * Window) const
{
    return (Window != NULL);
}

/********************************************/
 void LList :: ForEach
/********************************************/
(IterFuncType func, void * data)
{
    Start();
    while (OnList())
    {
       func (Current->data, data);
       MoveDown();
    }
}

/********************************************/
 MObject * LList :: FirstThat
/********************************************/
(CondFuncType func, void * data)
{
MObject * temp = NULL;
    Start();
    while (OnList() && temp == NULL);
    {
       if (func (Current->data, data) == TRUE)
	  temp = Current->data;
       MoveDown();
    }
    return (temp);
}

/********************************************/
 MObject * LList :: LastThat
/********************************************/
(CondFuncType func, void * data)
{
MObject * temp = NULL;
    End();
    while (OnList() && temp == NULL)
    {
       if (func (Current->data, data) == TRUE)
	  temp = Current->data;
       MoveUp();
    }
    return (temp);
}

/********************************************/
 void LList :: printOn
/********************************************/
(ostream& os)
{
LLElem * oldCurrent;
    oldCurrent = GetCurrent();
    Start();
    while (OnList())
    {
       os << Current->data;
       MoveDown();
    }
    MakeCurrent (oldCurrent);
}

/********************************************/
      LList :: ~LList (void)
/********************************************/
{
    Start();
    while (!IsEmpty())
       Delete();
}
