#include <mstd.h>
#include <mobject.h>
#include <mlist.h>
#include <mstaque.h>
#include <mtree.h>

/********************************************/
      MTree :: MTree
/********************************************/
(MTree * AParent, WORD MaxChildren)
{
    Children.MaxSize = MaxChildren;
    Parent = AParent;
}

/********************************************/
 void MTree :: AddChild
/********************************************/
(MTree * AChild)
{
    Children.End();
    Children.InsertAfter (AChild);
}

/********************************************/
 MTree * MTree :: RemoveChild
/********************************************/
(MTree * AChild)
{
    Children.Start();
    while (Children.OnList() && Children.Current->data != AChild)
       Children.MoveDown();

    if (Children.OnList())
       return ((MTree*)Children.Remove());
    else
       return (NULL);
}

/********************************************/
 void MTree :: DeleteChild
/********************************************/
(MTree * AChild)
{
MTree * temp;
    temp = RemoveChild (AChild);
    delete temp;
}

/********************************************/
 MTree * MTree :: FirstThat
/********************************************/
(CondFuncType func, void * data)
{
    if (func (this, data))
       return (this);
    else
       return ((MTree*) Children.FirstThat (func, data));
}

/********************************************/
 MTree * MTree :: LastThat
/********************************************/
(CondFuncType func, void * data)
{
    if (func (this, data))
       return (this);
    else
       return ((MTree*) Children.LastThat (func, data));
}

/********************************************/
 void MTree :: ForEach
/********************************************/
(IterFuncType func, void * data)
{
    func (this, data);
    Children.ForEach (func, data);
}

/********************************************/
 MTree * MTree :: Find
/********************************************/
(CondFuncType IsThat, void * param)
{
MTree * found = NULL;
MTree * child;
    if (IsThat (this, param))
       return (this);
    else
    {
       Children.Start();
       while (Children.OnList() && found == NULL)
       {
          child = (MTree*) Children.Retrieve();
	  found = child->Find (IsThat, param);
	  Children.MoveDown();
       }
    }
    return (found);
}
