#include <time.h>
#include <mio.h>
#include <mgr.h>
#include <mevent.h>

Queue EventQueue (MAX_EVENTS);

/********************************************/
 EVENT             GetEvent (void)
/********************************************/
{
static int oldx = 0,oldy = 0;
static buttonType oldbutton = noButtons;
static keyDelay = 0, mouseDelay = 0, oldTime = 0;
EVENT NewEvent;

    NewEvent = new MEvent;

    keyDelay += (clock() - oldTime);
    mouseDelay += (clock() - oldTime);
    oldTime += keyDelay;

    keyb.Update();
    mouse.Update();

    NewEvent->dest = HNUL;
    NewEvent->type = Nothing;

    if ((NewEvent->key = keyb.GetKey()) != 0 && keyDelay > keyb.RepeatDelay)
    {
       NewEvent->type |= KeyPressed;
       keyDelay = 0;
    }

    NewEvent->xpos = mouse.x();
    NewEvent->ypos = mouse.y();
    NewEvent->button = mouse.buttonStatus();

    if (NewEvent->xpos != oldx || NewEvent->ypos != oldy)
    {
       NewEvent->type |= MouseMoved;
       oldx = NewEvent->xpos;
       oldy = NewEvent->ypos;
    }

    if (NewEvent->button == noButtons && oldbutton != noButtons)
       NewEvent->type |= ButtonRelease;
    else if (NewEvent->button != noButtons && (oldbutton == noButtons || mouseDelay > mouse.RepeatDelay))
    {
       NewEvent->type |= ButtonPress;
       mouseDelay = 0;
    }
    oldbutton = NewEvent->button;

    if ((!EventQueue.IsFull() && NewEvent->type != Nothing) || (EventQueue.IsEmpty()))
       EventQueue.Append (NewEvent);
    else
       delete NewEvent;

    if (!EventQueue.IsEmpty())
       NewEvent = (MEvent*)(EventQueue.Serve());

    return (NewEvent);
}

/********************************************/
 void              WaitEvent
/********************************************/
(EVENT event)
{
    while (event->type == Nothing)
    {
	if (event != NULL)
	   delete event;
	event = GetEvent();
    }
}

/********************************************/
 void            FlushEvents (void)
/********************************************/
{
    EventQueue.Start();
    while (!EventQueue.IsEmpty())
       EventQueue.Delete();
}

/********************************************/
 void           CreateEvent
/********************************************/
(WORD AType, WORD TDSize, void * AData, LONG AValue, WORD ADest)
{
EVENT UserEvent;
    UserEvent = new MEvent;

    UserEvent->key     = 0;
    UserEvent->xpos    = 0xFFFF;
    UserEvent->ypos    = 0xFFFF;
    UserEvent->button  = noButtons;

    UserEvent->type    = AType;
    UserEvent->dest    = ADest;
    UserEvent->dSize   = TDSize;
    UserEvent->data    = AData;
    UserEvent->value   = AValue;

    if (!EventQueue.IsFull() && UserEvent->type != Nothing)
       EventQueue.Append (UserEvent);
    else
       delete UserEvent;
}


