Program Fade_Words;

Uses Graph,Crt;

Var
  Words:String[40];
  CurrColor,N:Integer;
  GraphDriver,GraphMode:Integer;

{$F+}
function DetectVGA256 : integer;
{ Detects VGA or MCGA video cards }
var
  DetectedDriver : integer;
  SuggestedMode  : integer;
begin
  DetectGraph(DetectedDriver, SuggestedMode);
  if (DetectedDriver = VGA) or (DetectedDriver = MCGA) then
    DetectVGA256 := 0        { Default video mode = 0 }
  else
    DetectVGA256 := grError; { Couldn't detect hardware }
end; { DetectVGA256 }
{$F-}

Procedure Initialize_Graphics;
var
  AutoDetectPointer : pointer;
  ErrorCode : byte;
  Maxcolor : Word;
  maxx : word;
  maxy : word;
{ Initialize graphics and report any errors that may occur }
var
  InGraphicsMode : boolean; { Flags initialization of graphics mode }
  PathToDriver   : string;  { Stores the DOS path to *.BGI & *.CHR }
begin
  { when using Crt and graphics, turn off Crt's memory-mapped writes }
  DirectVideo := False;
  PathToDriver := '';
  repeat
    AutoDetectPointer := @DetectVGA256;   { Point to detection routine }
    GraphDriver := InstallUserDriver('VGA256', AutoDetectPointer);
    GraphDriver := Detect;
    InitGraph(GraphDriver, GraphMode, PathToDriver);
    ErrorCode := GraphResult;             { preserve error return }
    if ErrorCode <> grOK then             { error? }
    begin
      Writeln('Graphics error: ', GraphErrorMsg(ErrorCode));
      if ErrorCode = grFileNotFound then  { Can't find driver file }
      begin
        Writeln('Enter full path to BGI driver or type <Ctrl-Break> to quit:');
        Readln(PathToDriver);
        Writeln;
      end
      else
        Halt(1);                          { Some other error: terminate }
    end;
  until ErrorCode = grOK;
  Randomize;                { init random number generator }
  MaxColor := GetMaxColor;  { Get the maximum allowable drawing color }
  MaxX := GetMaxX;          { Get screen resolution values }
  MaxY := GetMaxY;
end; { Initialize }

Begin
  Initialize_Graphics;
  Words:=' Software Presents';
  CurrColor:=16;
  Repeat
    SetColor(CurrColor);
    OutTextXY(84,100,Words);
    Delay(80);
    Inc(CurrColor);
  Until CurrColor=32;
  Dec(CurrColor);
  Delay(3000);
  Repeat
    SetColor(CurrColor);
    OutTextXY(84,100,Words);
    Delay(80);
    Dec(CurrColor);
  Until CurrColor=15;
  CloseGraph;
End.