; C far-callable as:
; void PutScale (int imageSeg, int imageOff, int imageWidth, int imageHeight,
;        int destSeg, int destOff, int destWidth, int destStart, int SizeX,
;	 int SizeY)
; set tab size to 8


	.286
	.model  large
	.code

public  _PutScale
_PutScale    proc    far

	arg	imageSeg,imageOff,imageWidth,imageHeight,destSeg,destOff,destWidth,destStart,SizeX,SizeY

	push	bp	;preserve caller stack frame
	mov   	bp,sp   ;point to local stack frame

	pusha
	push	es
	push	ds


	push  	imageSeg
	pop	ds                      ;DS image seg
	push	destSeg
	pop	es			;ES dest seg
	mov	si,imageOff		;SI image start
	mov   	di,destStart		;DI dest offset
	mov   	bh,byte ptr SizeX      	;BH xsize
	mov	bl,byte ptr SizeY	;BL ysize

	;calculate x increment

	mov   	ah,bh                   ;AX xsize*256
	shr	ah,2			; AH and /4 to avoid divide errors
	xor   	al,al                   ; AL clear
	mov	dx,imageWidth		;DX
	div   	dl			;AX divide size*256 by image width
	jz    	falldone                ;AX zero, nothing to do
	mov   	bh,al                   ;BH X increment/4

	;calculate y increment

	mov	ah,bl			;AX ysize*256
	shr	ah,2			; AH and /4 to avoid divide errors
	xor	al,al			; AL clear
	mov	dx,imageHeight		;DX
	div	dl			;AX divide size*256 by image height
	jz	falldone			;AX zero, nothing to do
	mov	bl,al			;BL Y increment/4

	xor	ax,ax			;AX clear
	xor	cx,cx			;CX clear
	mov   	dl,byte ptr imageHeight	;DL row count

frowstart:
	mov	ah,ch			;AH,CH store copy of CH
	push	bx			;BX save
	xor	bh,bh			;BX use BL for increment
	shl	bx,2			;BX increment was /4 above
	add	cx,bx			;CX increment by BL
	pop	bx			;BX restore
	mov	al,ch			;AL,CH used part of counter to AL
	sub	al,ah			;number of rows to draw

	push	cx			;CX save, X also uses this reg
	xor	cx,cx			;CX clear, start X counting at 0

	inc	al			;AL increment for below decrement
frowloop:
	dec	al			;AL MUST have added one above
	jz	frowdone		;AL done with this row

	push	ax			;AX X will also use this reg
	push	di                      ;DI save screen offset

	mov	dh,byte ptr imageWidth	;DH pixel width
fcolstart:
	mov	ah,ch			;AH,CH store copy of CH
	push	bx			;BX save
	shr	bx,8			;BX use BH for increment
	shl	bx,2			;BX increment was /4 above
	add	cx,bx			;CX increment by BH
	pop	bx			;BX restore
	mov	al,ch			;AL,CH used part of counter to AL
	sub	al,ah			;number of pixels to draw

	inc	al			;AL increment for below decrement
fcolloop:
	dec   	al                      ;AL Must have added one above
	jz    	fcoldone		;AL Done with this pixel

	;DRAW PIXEL
	;ADD IGNORE COLOR HANDLER HERE
	mov     ah,byte ptr ds:[si]     ;AH one pixel from image
	mov     byte ptr es:[di],ah     ;AH to dest, maybe screen

	inc     di                      ;DI inc dest pointer
	jmp     fcolloop                ;DI Finish this pixel

fcoldone:
	inc     si                      ;SI inc image
	dec     dh                      ;DH count cols
	jnz     fcolstart               ;more cols in row?

	pop     di
	pop	ax			;AX Y needs this counter reg

	sub	si,imageWidth		;SI backup for row repeat
	add     di,destWidth		;DI advance to next row
	jmp	frowloop		;check for row repeating

frowdone:
	add	si,imageWidth		;SI advance to next row
	pop	cx			;CX done with it, Y inc needs it now

	dec     dl                      ;DL count rows
	jnz     frowstart              	;more lines in image?

falldone:
	pop	ds
	pop	es
	popa

	pop	bp	;restore caller stack frame
	retf
_PutScale    endp


end


