

#include <iostream.h>
#include <fstream.h>
#include <dos.h>
#include <conio.h>

//	NOTES:

/*
	This is a rough first draft, very sloppy, but I'm just happy to finally
	see the damned thing working.  Such as it is, consider it to be released
	into the public domain, to be folded, spindled and mutilated as needs be.

	The assembler will need quite a bit of optimization, and get's sketchy
	when you try to scale too small.  The trouble is that the division factor
	goes over the byte limit, and gives a divide error.  I've already shifted
	the whole thing by two bits to compensate, and limited the range to 64
	pixels, instead of 256.

	It might also make sense to create a special case handler for when no
	scaling is necassary.

	The calling function should be changed to accept pointers instead of
	ints, I just didn't want to deal with it.

	Thanks to all in the Game Design forum.

	Jesse Montrose [76646,3302]

*/


typedef unsigned char byte;
typedef unsigned int word;

extern "C" void PutScale (int imageSeg, int imageOff, int imageWidth,
	int imageHeight, int destSeg, int destOff, int destWidth,
	int destStart, int SizeX, int SizeY);

int LoadPCX(char *name);

byte far *image;
int imageWidth;		// original bitmap width
int imageHeight;	// and height

void main (int argc, char *argv[]) {


	if (argc < 2) {
		cout << "\n\nusage: PUTSCALE image.pcx\n\n";
		return;
	}

	cout << "\n\n	Controls: UP-ARROW, DOWN-ARROW, ESC.";
	cout << "\n\n   I guess you can figure out what they do.\n\n";
	while (!kbhit());

	char *filename=argv[1];

	asm {
		push ax
		mov ah,0x00
		mov al,0x13
		int 0x10
		pop ax
	}

	if (!LoadPCX (filename))
		return;

	int imageSeg=FP_SEG(image);
	int imageOff=FP_OFF(image);

	int SizeX=imageWidth;	// new size x to scale to
	int SizeY=imageHeight;	// new size y to scale to

	int destWidth=320;		// dest could also be another bitmap
	int destStart=destWidth*100+40;
	int destSeg=0xa000;		// video seg
	int destOff=0;

	char ch='\0';

	while (ch!=27) {
		PutScale (imageSeg, imageOff, imageWidth, imageHeight, destSeg,
			destOff, destWidth, destStart, SizeX, SizeY);

		ch=getch();
		switch (ch) {
			case 72:	// up arrow, increase size as if moving closer

				if (SizeX+4<61) {
					SizeX+=4;
					SizeY+=4;
				}
				break;
			case 80:	// down arrow, decrease size as if moving away
				if (SizeX-4>3) {
					SizeX-=4;
					SizeY-=4;
				}
				break;
		}
	}

	// back to text mode.
	asm {
		push	ax
		mov	ah,0x00
		mov	al,0x03
		int	0x10
		pop	ax
	}
}

struct pcx_hdr {
	char Mfg;				// manufacturer, always 0xa0
	char Ver;				// encoder version number
	char Enc;				// encoding code, always 1
	char Bpp;				// bits per pixel, 8 in mode 0x13
	int	 Xmin,Ymin;			// image origin, usually 0,0
	int	 Xmax,Ymax;			// image dimensions
	int	 Hres;				// horizontal resolution value
	int	 Vres;				// vertical resolution value
	char Pal[48];			// palette (not in mode 0x13)
	char Reserved;       	// who knows?
	char ClrPlanes;	    	// number of planes, 1 in mode 0x13
	int	 Bpl;				// bytes per line, 80 in mode 0x13
	int	 PalType;			// Grey or Color palette flag
	char Filler[58];		// Zsoft wanted a 128 byte header
};

int LoadPCX(char *name) {

	ifstream pcx (name, ios::binary);
	if (!pcx) {
		cout << "Couldn't open " << name << "\n";
		return 0;
	}

	unsigned int     bytes=0;       // counts unpacked bytes
	unsigned char    c;             // byte being processed
	unsigned int     runlen;        // length of packet
	unsigned int num_bytes;

	char pcxColors[3*256];

	pcx_hdr pcxh;

	pcx.read ( (char*) &pcxh, sizeof (pcxh) );

	imageWidth=pcxh.Xmax+1;
	imageHeight=pcxh.Ymax+1;

	num_bytes = imageWidth*imageHeight;

	image= new far byte[num_bytes+1];
	if (image==NULL) {
		cout << "out of mem on file " << name << "\n";
		return 0;
	}

	do {
		pcx.get (c);

		if ((c & 0xc0) == 0xc0)	{	// high 2 bits set is packet
			runlen = (c & 0x3f);	// AND off the high bits
			pcx.get (c);
			while(runlen--)	(image[bytes++]=c);
		} else
			image[bytes++]=c;
	} while (bytes<num_bytes);

	pcx.get(c);	// this is a marker before the palette


	for (int i=0; i<(3*256); i++) {
		pcx.get (c);
		pcxColors[i]= (c >> 2);
	}


	// set palette

	int offcol=FP_OFF(pcxColors);
	int segcol=FP_SEG(pcxColors);
	asm{
		mov	dx,es
		push	dx
		mov	dx,segcol
		mov	es,dx
		mov	dx,offcol
		mov	ah,0x10
		mov	al,0x12
		mov	bx,0
		mov	cx,0x100
		int	0x10
		pop	dx
		mov	es,dx
	}


	return 1;
}


