Program VSPEdit2;
Uses SPX_VGA, Mouse, Crt, Dos;
Const
  TMXRange = 5; { <= TMXRange * BS <= 150 }
  TMYRange = 5; { <= TMYRange * BS <= 150 }
  TMTiles = 20;  {TMTiles * (TMXRange+1) <= 319}
  BS = 5;
  M = BS - 1;


Type
  VSPFileType = File of Byte;
  VSPTypePtr = ^VSPType;
  VSPType = Record
    Width, Height : Word;
    Map : Array[1..TMXRange,1..TMYRange] of Byte;
  End;


Var
  Letter : Array[1..35] of Pointer;
  Number : Array[0..9] of Pointer;
  Arrow : Array[1..2] of Pointer;
  VSPEditPic, Temp : Pointer;
  B, T : Byte;
  W, G1, G2 : LongInt;
  VSP : Array[1..TMTiles] of VSPTypePtr;
  VSPFile : VSPFileType;
  MouseState : Integer;
  ButtonPressed, H, V, PaletteState, X, Y, Z, A : Integer;
  GamePalette : RGBList;
  EnterKey : Char;
  CurrColor : Byte;
  C, CurrShip : Byte;
  ShipSprites : Array[1..TMTiles] of Pointer;
  SaveName, S : String;
  Ch : Char;

Procedure VS;

Begin
  VSinc;
  VSinc;
End;

Procedure ClearScreen;

Begin
  FPCopy(Pages[2]^, Pages[1]^);
End;

Procedure Pause;

Begin
  Repeat until KeyPressed;
  Ch := ReadKey;
End;

Procedure Swap(Var N1, N2 : VSPType);

Var
  T1 : VSPType;

Begin
  T1 := N1;
  N1 := N2;
  N2 := T1;
End;


Procedure OutTextXY(X, Y : Integer; S : String);

Var N : Integer;

Begin
  For N := 1 to Length(S) do
    If (S[N]) in ['A'..'c'] Then
      FtPut(X + N * 5, Y, Letter[Ord(S[N])-64]^,False)
    Else If S[N] in ['0'..'9'] Then
      FtPut(X + N * 5, Y, Number[Ord(S[N])-Ord('0')]^,False);
End;


Procedure Dir;

Var
  X, Y : Byte;
  FileName : String;
  DirInfo : SearchRec;
  T : String;

Procedure ReplacePeriods(Var S : String);

Var
  X : Byte;

Begin
  For X := 1 to Length(S) do
    Begin
      If S[X] = '.' Then S[X] := '_'
      Else If S[X] = '_' then S[X] := ' ';
    End;
End;

Begin
  ClearScreen;
  OutTextXY(93,5,'LOADING VGA SPRITE FILES___');
  X := 0;
  Y := 3;
  FindFirst('*.VSP',Archive,DirInfo);
  While DosError = 0 do
    Begin
      T := DirInfo.Name;
      ReplacePeriods(T);
      If X <> 0 Then
        FtPut(X*5-5,Y*5,Letter[Ord('a')-64]^,False);
      OutTextXY(X*5-5,Y*5,T);
      Inc(X,13);
      If X >= 64 then Begin
        X := 0;
        Inc(Y,2);
        If Y >= 38 then Begin
          OutTextXY(29*5,39*5,'[MORE]');
          Repeat Until KeyPressed;
          ClearScreen;
          Y := 1;
          Ch := ReadKey;
        End;
      End;
      FindNext(DirInfo);
    End;
  OutTextXY(X*5,Y*5,'[DONE]');
End;

Function ToThe(Q, W : Integer) : LongInt;

Var
  E : Integer;
  T : LongInt;

Begin
  T := 1;
  For E := 1 to W do
    T := T * Q;
  If W <> 0 Then
    ToThe := T
  Else ToThe := 1;
End;

Procedure OutNumXY(X, Y : Integer; N : LongInt; DispZeros : Boolean);

Var
  L, J, P : Integer;
  T : LongInt;

Begin
  P := 1;
  T := N;
  L := 0;
  While T / ToThe(10,L) >= 1 do
    Inc(L);
  If DispZeros Then
    For J := 1 to 10 - L do
      Begin
        FtPut(X + P * 5, Y, Number[0]^,False);
        Inc(P);
      End;
  For J := L - 1 downto 0 do
    Begin
      FtPut(X + P * 5, Y, Number[T div ToThe(10,J)]^,False);
      T := T - T div ToThe(10,J) * ToThe(10,J);;
      Inc(P);
    End;
End;

Procedure UpdateVSPNumber;

Begin
  Bar(232,192,286,197,0);
  OutNumXY(232,192,CurrShip,True);
End;

Procedure EnterNumXY(X, Y : Integer; Var N : LongInt );

Var
  P,U,C : Byte;
  T,R : String;
  Ch : Char;
  E : Integer;
  Up : Boolean;

Begin
  P := 0;
  T := '';
  C := 0;
  Repeat
    Repeat
      FtPut(X + (P+1) * 5, Y, Letter[Ord('a')-64+C]^,False);
      Delay(40);
      CopyRect(X+(P+1)*5,Y,X+(P+2)*5,Y+5,Pages[2]^,Pages[1]^);
      If (C = 2) and Up then Up := False;
      If (C = 0) and Not Up then Up := True;
      If Up then Inc(C) Else Dec(C);
    Until KeyPressed;
    Ch := ReadKey;
    If (Ch = #8) And (P > 0) Then Begin
      Dec(P);
      R := '';
      For U := 1 to P do
        R := R + T[U];
      CopyRect(X+(P+1)*5,Y,X+(P+2)*5,Y+5, Pages[2]^, Pages[1]^);
      T := R;
    End
    Else If (UpCase(CH) in ['0'..'9']) And (P < 10) Then Begin
      Inc(P);
      T := T + CH;
    End;
    For U := 1 to P do
      If T[U] <> #32 Then
        FtPut(X + U * 5, Y, Number[Ord(T[U])-Ord('0')]^,False);
  Until Ch = #13;
  Val(T,N,E);
End;

Procedure EnterTextXY(X, Y, L : Integer; Var S : String; Out : Boolean );

Var
  Up : Boolean;
  P,U,C : Byte;
  T,R : String;
  CH : Char;

Begin
  P := 0;
  T := '';
  C := 0;
  Up := True;
  Repeat
    Repeat
      FtPut(X + (P+1) * 5, Y, Letter[Ord('a')-64+C]^,False);
      Delay(40);
      CopyRect(X+(P+1)*5,Y,X+(P+2)*5,Y+5,Pages[2]^,Pages[1]^);
      If (C = 2) and Up then Up := False;
      If (C = 0) and Not Up then Up := True;
      If Up then Inc(C) Else Dec(C);
    Until KeyPressed;
    CH := ReadKey;
    If (CH = #8) And (P > 0) Then Begin
      Dec(P);
      R := '';
      For U := 1 to P do
        R := R + T[U];
      If (T[P+1] <> #32) Then
        CopyRect(X+(P+1)*5, Y,X+(P+2)*5, Y+5, Pages[2]^, Pages[1]^);
      T := R;
    End
    Else If (UpCase(CH) in ['A'..'Z',' ','.','0'..'9']) And (P < L) Then Begin
      Inc(P);
      If CH <> '.' then
        T := T + UpCase(CH)
      Else
        T := T + '_';
    End;
    For U := 1 to P do
      If (T[U] <> #32) and Out Then
        If T[U] in ['0'..'9'] Then
          FtPut(X + U * 5, Y, Number[Ord(T[U])-Ord('0')]^,False)
        Else FtPut(X + U * 5, Y, Letter[Ord(T[U])-64]^,False);
  Until (Ch = #13);
  For U := 1 to P do
    If T[U] = '_' Then T[U] := '.';
  S := T;
End;

Procedure FillPixel(ColorOn,ColorKill,CXLoc,CYLoc:Integer);

Begin {FillPixel}
  If (VSP[CurrShip]^.Map[CXLoc,CYLoc]=ColorOn)
    Then Begin
      VSP[CurrShip]^.Map[CXLoc,CYLoc]:=ColorKill;
      Bar(CXLoc*BS-M,CYLoc*BS-M,CXLoc*BS,CYLoc*BS,VSP[CurrShip]^.Map[CXLoc,CYLoc]);
      PSet(201+CXLoc,81+CYLoc,CurrColor);
      If CYLoc<TMYRange Then FillPixel(ColorOn,ColorKill,CXLoc,CYLoc+1);
      If CYLoc>1 Then FillPixel(ColorOn,ColorKill,CXLoc,CYLoc-1);
      If CXLoc<TMXRange Then FillPixel(ColorOn,ColorKill,CXLoc+1,CYLoc);
      If CXLoc>1 Then FillPixel(ColorOn,ColorKill,CXLoc-1,CYLoc);
    End;
End; {FillPixel}

Procedure ShowCurrColor;

Var G : String;

Begin
  Bar(202,1,237,36,CurrColor);
  Bar(202,45,225,50,0);
  Str(CurrColor,G);
  OutTextXY(198,45,G);
End;

Procedure DrawBackGround;

Var C, D : Byte;

Begin
  Randomize;
  Rectangle(0,0,319,199,25);
  Rectangle(0,0,BS*TMXRange+1,BS*TMYRange+1,25);
  Rectangle(238,0,319,81,25);
  Rectangle(201,0,238,37,25);
  Rectangle(201,81,202+TMXRange,82+TMYRange,25);
  Rectangle(201,0,319,81,25);
  Rectangle(201,81,302,182,25);
  Rectangle(201,0,319,199,25);
  Rectangle(205,182,225,199,25);
  Rectangle(299,182,319,199,25);
  OutTextXY(198,39,'COLOR');
  OutTextXY(198,51,'aPLUS');
  OutTextXY(198,57,'aMINUS');
  OutTextXY(198,63,'aRIGHT');
  OutTextXY(198,69,' MOUSE');
  OutTextXY(198,75,' BUTTON');
  OutTextXY(232,184,'VSP NUMBER');
  UpdateVSPNumber;
  FtPut(210,186,Arrow[2]^,False);
  FtPut(304,186,Arrow[1]^,False);
  FtPut(303,82,VSPEditPic^,False);
  For D := 1 to 16 do
    For C := 1 to 16 do
      Bar(234+D*5,C*5-4,238+D*5,C*5,(D-1)*16+C-1);
End;

Procedure OutputCommands;

Begin
  OutTextXY(2,2,'VSP EDIT 2_2 [BY TESLA OF Z8\SOFT]');
  OutTextXY(2,12,'COMMANDS\');
  OutTextXY(2,22,'a [S]AVE VSP FILE');
  OutTextXY(2,32,'a [L]OAD VSP FILE');
  OutTextXY(2,42,'a [N]EW VSP FILE');
  OutTextXY(2,52,'a [Q]UIT VSP EDIT 2_0');
  OutTextXY(2,62,'a [E]RASE VSP');
  OutTextXY(2,72,'a [C]OPY VSP');
  OutTextXY(2,82,'a [X]CHANGE VSP');
  OutTextXY(2,92,'a [F]ILL AREA');
  OutTextXY(2,102,'a [R]EVERSE X COPY VSP');
  OutTextXY(2,112,'a [I]NTERCHANGE COLORS');
  OutTextXY(2,122,'a [V]IEW COMMANDS');
  OutTextXY(2,132,'a [PGUP] JUMP TO 1ST VSP');
  OutTextXY(2,142,'a [PGDN] JUMP TO LAST VSP');
  OutTextXY(2,152,'a [RIGHT] NEXT VSP');
  OutTextXY(2,162,'a [LEFT] PREVIOUS VSP');
  OutTextXY(2,172,'a [T]ILE PICTURE');
  OutTextXY(2,182,'a [P]ALETTE ROTATION');
  Pause;
End;

Procedure DrawTile;

Var X, Y : Byte;

Begin
  For X := 1 to TMXRange do
    For Y := 1 to TMYRange do
      Begin
        Bar(X*BS-M,Y*BS-M,X*BS,Y*BS,VSP[CurrShip]^.Map[X,Y]);
        PSet(X+201,Y+81,VSP[CurrShip]^.Map[X,Y]);
      End;
End;

Procedure RotatePalette;

Var
  P : RGBList;
  T : Byte;

Begin
  P := GamePalette;
  Repeat
    ColorCycle(P,8,7,True);
    ColorCycle(P,1,7,False);
    For T := 1 to 10 do
      ColorCycle(P,221 + T * 3,3,True);
    VSinc;
    FSetColors(P);
    VSinc;
    Delay(50);
    GetMouse(ButtonPressed, H, V);
  Until KeyPressed or (ButtonPressed <> 0);
  If KeyPressed then Ch := ReadKey;
  FSetColors(GamePalette);
End;

Begin
  H := LoadVSP('SALPHA.VSP', Letter);
  H := LoadVSP('SNUMERAL.VSP', Number);
  H := LoadVSP('ARROWS.VSP', Arrow);
  H := LoadVSP('VSPEDIT.VSP',VSPEditPic);
  OpenMode(2);
  PaletteState := LoadColors('GamePal.Pal',GamePalette,256);
  FSetColors(ZDC);
  MouseState := MouseReset;
  CurrShip := 1;
  DrawBackGround;
  For C := 1 to TMTiles do
    Begin
      New(VSP[C]);
      VSP[C]^.Height := TMYRange;
      VSP[C]^.Width := TMXRange;
      For X := 1 to TMXRange do
        For Y := 1 to TMYRange do
          VSP[C]^.Map[X,Y] := 0;
    Currship := C;
    DrawTile;
  End;
  CurrShip := 1;
  EnterKey := ' ';
  CurrColor := 1;
  FadeIn(50,GamePalette);
  ShowCurrColor;
  MouseOn;
  Repeat
    Repeat
      GetMouse(ButtonPressed, H, V);
    Until (ButtonPressed <> 0) or KeyPressed;
    If KeyPressed Then Begin
      EnterKey := ReadKey;
      Case EnterKey of
        #0 : Begin
          Ch := ReadKey;
          Case Ch of
            #73 : CurrShip := 1;
            #81 : CurrShip := TMTiles;
            'M' : If CurrShip < TMTiles Then Inc(CurrShip);
            'K' : If CurrShip > 1 Then Dec(CurrShip);
          End;
          VS;
          MouseOff;
          UpdateVSPNumber;
          DrawTile;
          MouseOn;
        End;
        '+' : Begin
          Inc(CurrColor);
          If CurrColor > 255 Then CurrColor := 0;
          MouseOff;
          ShowCurrColor;
          MouseOn;
        End;
        '-' : Begin
          Dec(CurrColor);
          If CurrColor < 0 Then CurrColor := 255;
          MouseOff;
          ShowCurrColor;
          MouseOn;
        End;
        'T','t' : Begin
          VS;
          MouseOff;
          CopyRect(1,1,200,198,Pages[2]^,Pages[1]^);
          X := 198 div TMXRange;
          Y := 198 div TMYRange;
          For A := 1 to X do
            For Z := 1 to Y do
              CopyTo(202,82,201+TMXRange,81+TMYRange,(A-1)*TMXRange+1,(Z-1)*TMYRange+1,Pages[1]^,Pages[1]^);
          RotatePalette;
          CopyRect(1,1,200,198,Pages[2]^,Pages[1]^);
          DrawBackGround;
          DrawTile;
          MouseOn;
        End;
        'V','v' : Begin
          VS;
          MouseOff;
          CopyRect(1,1,200,198,Pages[2]^,Pages[1]^);
          OutputCommands;
          CopyRect(1,1,200,198,Pages[2]^,Pages[1]^);
          DrawBackGround;
          DrawTile;
          MouseOn;
        End;
        'C','c' : Begin
          MouseOff;
          ClearScreen;
          OutTextXY(0,0,'COPY TILE NUMBER\');
          EnterNumXY(17*5,0,G1);
          OutTextXY(0,10,'TO TILE NUMBER\');
          EnterNumXY(16*5,10,G2);
          For X := 1 to TMXRange do
            For Y := 1 to TMYRange do
              VSP[G2]^.Map[X,Y] := VSP[G1]^.Map[X,Y];
          ClearScreen;
          DrawBackGround;
          For C := 1 to TMTiles do
            Begin
              CurrShip := C;
              DrawTile;
            End;
          MouseState := MouseReset;
          MouseOn;
        End;
        'R','r' : Begin
          MouseOff;
          ClearScreen;
          OutTextXY(0,0,'REVERSE X COPY TILE NUMBER\');
          EnterNumXY(28*5,0,G1);
          OutTextXY(0,10,'TO TILE NUMBER\');
          EnterNumXY(16*5,00,G2);
          For X := 1 to TMXRange do
            For Y := 1 to TMYRange do
              VSP[G2]^.Map[TMXRange-X+1,Y] := VSP[G1]^.Map[X,Y];
          ClearScreen;
          DrawBackGround;
          For C := 1 to TMTiles do
            Begin
              CurrShip := C;
              DrawTile;
            End;
          MouseState := MouseReset;
          MouseOn;
        End;
        'X','x' : Begin
          MouseOff;
          ClearScreen;
          OutTextXY(0,0,'EXCHANGE TILE NUMBER\');
          EnterNumXY(21*5,0,G1);
          OutTextXY(0,10,'WITH TILE NUMBER\');
          EnterNumXY(18*5,10,G2);
          Swap(VSP[G1]^, VSP[G2]^);
          DrawBackGround;
          For C := 1 to TMTiles do
            Begin
              CurrShip := C;
              DrawTile;
            End;
          MouseState := MouseReset;
          MouseOn;
        End;
        'S','s' : Begin
          MouseOff;
          ClearScreen;
          OutTextXY(0,0,'SAVE AS\');
          EnterTextXY(9*5,0,12,SaveName,True);
          ClearScreen;
          DrawBackground;
          Assign(VSPFile,SaveName);
          ReWrite(VSPFile);
          For C := 1 to TMTiles do
            Begin
              B := TMXRange; {30}
              Write(VSPFile,B);
              B := 0; {0}
              Write(VSPFile,B);
              B := TMYRange; {30}
              Write(VSPFile,B);
              B := 0; {0}
              Write(VSPFile,B);
              For Y := 1 to TMYRange do
                For X := 1 to TMXRange do
                  Write(VSPFile,VSP[C]^.Map[X,Y]);
              CurrShip := C;
              DrawTile;
            End;
          CurrShip := 1;
          Close(VSPFile);
          MouseState := MouseReset;
          MouseOn;
        End;
        'E','e' : Begin
          For X := 1 to TMXRange do
            For Y := 1 to TMYRange do
              VSP[CurrShip]^.Map[X,Y] := 0;
          MouseOff;
          DrawTile;
          MouseOn;
        End;
        'F','f' : Begin
          Repeat
            GetMouse(ButtonPressed, H, V);
          Until ButtonPressed <> 0;
          MouseOff;
          If (H div 2<TMXRange*BS)and(V<TMYRange*BS)and(Point(H div 2,V,1)<>CurrColor)
            Then FillPixel( Point(H div 2, V,1), CurrColor, H div 2 div BS + 1, V div BS + 1);
          MouseOn;
        End;
        'I','i' : Begin
          Repeat
            GetMouse(ButtonPressed, H, V);
          Until ButtonPressed <> 0;
          T := Point(H div 2,V,1);
          For X := 1 to TMXRange do
            For Y := 1 to TMYRange do
              If VSP[CurrShip]^.Map[X,Y] = t Then
                VSP[Currship]^.Map[X,Y] := CurrColor;
          MouseOff;
          DrawTile;
          MouseOn;
        End;
        'N','n' : Begin
          For C := 1 to TMTiles do
            Begin
              For X := 1 to TMXRange do
                For Y := 1 to TMYRange do
                  VSP[C]^.Map[X,Y] := 0;
              MouseOff;
              CurrShip := C;
              DrawTile;
             MouseOn;
           End;
         Currship := 1;
        End;
        'P','p' : RotatePalette;
        'L','l' : Begin
          MouseOff;
          ClearScreen;
          Dir;
          Repeat
            OutTextXY(0,194,'LOAD\');
            EnterTextXY(30,194,12,SaveName,True);
            {$I-}
            MouseState := LoadVSP(SaveName,ShipSprites[1]);
            {$I+}
          Until IOResult = 0;
          ClearScreen;
          DrawBackGround;
          For C := 1 to TMTiles do
            Begin
              Bar(202,82,201+TMXRange,81+TMXRange,0);
              FtPut(202,82,ShipSprites[C]^,False);
              For X := 1 to TMXRange do
                For Y := 1 to TMYRange do
                  VSP[C]^.Map[X,Y] := Point(201+X,81+Y,1);
            End;
          DrawTile;
          MouseOn;
        End;
      End;
    End
    Else
      Begin
        If (ButtonPressed=1) Then
          Begin
            If (H div 2<BS*TMXRange) and (V<BS*TMYRange) Then
              Begin
                VS;
                MouseOff;
                PSet(201+H div 2 div BS+1,82+V div BS,CurrColor);
                H := H div 2 div BS + 1;
                V := V div BS + 1;
                Bar(H*BS-M,V*BS-M,H*BS,V*BS,CurrColor);
                VSP[CurrShip]^.Map[H,V] := CurrColor;
                MouseOn;
              End
            Else If (H div 2 > 202) and (V > 182) Then
              Begin
                If (H div 2 < 225) and (CurrShip > 1) Then Dec(CurrShip)
                Else If (H div 2 < 304) Then H := 0
                Else If CurrShip < TMTiles Then Inc(CurrShip);
                VS;
                MouseOff;
                DrawTile;
                UpdateVSPNumber;
                MouseOn;
              End;
          End
        Else
          Begin
            VS;
            MouseOff;
            CurrColor := Point(H div 2,V,1);
            ShowCurrColor;
            MouseOn;
          End;
    End;
  Until EnterKey in ['Q','q'];
  CloseMode;
End.
