Unit VGA256;

Interface

Uses Dos, Graph;

Type
  DacPalette256 = array[0..255] of array[0..2] of Byte;

  Point = Record
    X, Y : Integer;
  End;

  Pixel = Record
    X, Y : Integer;
    C : Byte;
  End;

  PixFunc = Function(RX, IY : Integer) : Byte;

Const

  VMSConst : Array[0..4] of String = ( 'SVGA 320x200x256',
           'SVGA 640x400x256', 'SVGA 640x480x256', 'SVGA 800x600x256',
           'SVGA 1024x768x256');

Var
  SaveBM : Pointer;
  SA : Point;
  LN10 : Extended;
  MaxIter : LongInt;
  StartX, StartY, SizeX, SizeY, Bounds : Extended;
  Colors, OffX, OffY, MaxX, MaxY : Integer;
  InSetColor : Byte;
  CopyTB : Boolean;
  CurrFunc : PixFunc;

Function ChooseVM : Byte;

Procedure InitVideoMode(V : Byte; B : Boolean);

Implementation

{$I SVGA256.INC}

Function ChooseVM : Byte;

VAr
  Z : Byte;
  ZZ : Integer;
  C : String;

Begin
  Repeat
    WriteLn('Use what video mode?');
    For Z := 0 to 4 do
      WriteLn(Z,') ',VMSConst[Z]);
    ReadLn(C);
    Val(C,Z,ZZ);
  Until Z in [0..4];
  ChooseVM := Z;
End;

Procedure InitVideoMode(V : Byte; B : Boolean);

Var
  GrGraph, GrMode : Integer;

{$F+}
Function R320x200 : Integer;

Begin
  R320x200 := SVGA320x200x256;
End;

Function R640x400 : Integer;

Begin
  R640x400 := SVGA640x400x256;
End;

Function R640x480 : Integer;

Begin
  R640x480 := SVGA640x480x256;
End;

Function R800x600 : Integer;

Begin
  R800x600 := SVGA800x600x256;
End;

Function R1024x768 : Integer;

Begin
  R1024x768 := SVGA1024x768x256;
End;
{$F-}

Begin
  Case V of
    0 : GrGraph := InstallUserDriver('SVGA256', @R320x200);
    1 : GrGraph := InstallUserDriver('SVGA256', @R640x400);
    2 : GrGraph := InstallUserDriver('SVGA256', @R640x480);
    3 : GrGraph := InstallUserDriver('SVGA256', @R800x600);
    4 : GrGraph := InstallUserDriver('SVGA256', @R1024x768);
  End;
  GrGraph := Detect;
  InitGraph(GrGraph,GrMode,'');
  If B Then
    Bar(0,0,GetMaxX,GetMaxY);
  MaxX := GetMaxX;
  MaxY := GetMaxY;
  OffX := 0;
  OffY := 0;
End;

End.