Program MUDgame;
Uses Globals,Extras,CRT;
{$V-}

Type ObjList = Array[1..16000,1..2] of Integer;
     DoorList = Array[1..80] of DoorType;
     ObjectTypeList = Array[1..200] of ^ObjectType;

Var U : UserType;
    R : array[1..3] of RoomType;
    O : ObjectTypeList;
    M : MobType;
    K : ^ObjList;
    D : ^DoorList;

Procedure ShowVersion;
Begin
 Writeln;
 Writeln('MUD OS/2 version 1.1a  7/3/93 - alpha version');
 Writeln('Created by Herb Gilliland for Z8Soft');
 Writeln;
End;

{$I STRINGS.PAS}
{$I USER.PAS}
{$I OBJECT.PAS}
{$I HELP.PAS}

Procedure SetUpDefaults;
Var X,Y : Integer;
Begin
 New(K);
 New(D);
 For X := 1 to 200 do New(O[X]);
 For X := 2 to 16000 do For Y := 1 to 2 do K^[X,Y] := -1;
 K^[1,1] := 1;
 K^[1,2] := 1;
 K^[2,1] := 3;
 K^[2,2] := 2;
 For X := 3 to 30 do
  Begin
   K^[X,1] := 2;
   K^[X,2] := 2;
  End;
 With U do begin
  Charname := 'Locke';
  Sdesc := 'Locke the Younger';
  Desc := 'You see nothing special.';
  Username := 'Joe Public';
  Flagwords := 'locke player';
  MoveTotal := 0;
  Hp := 25;
  HpMax := Hp;
  M := 100;
  MMax := M;
  Mv := 100;
  MvMax := Mv;
  Class := Thief;
  If Class = Warrior then BSTR := 12+RollEm(1,4) else BSTR := 8 + RollEm(1,5);
  If Class = Mage then BINT := 12+RollEm(1,4) else BINT := 8 + RollEm(1,5);
  If Class = Cleric then BWIS := 12+RollEm(1,4) else BWIS := 8 + RollEm(1,5);
  If Class = Thief then BDEX := 12+RollEm(1,4) else BDEX := 8 + RollEm(1,5);
  BCON := 8 + RollEm(1,5);
  BAge := 17;
  BSex := False;
  For X := 1 to 25 do I[X].ObjNum := -1;
  For X := 1 to 13 do W[X].ObjNum := -1;
  Level := 1;
  Hitroll := 0;
  Damroll := 0;
  BAlign := 0;
  Armor := 100;
 end;
 ResetUserStats(U);
 For X := 1 to 3 do
  With R[x] do begin
   Name := '@MThe Room@M';
   Desc := 'You see a large red ''Q'' written in blood on the carpet here.@MThe sun shows through windows to the north.@M';
   For Y := 1 to 8 do Room[y] := NORMAL;
   Room[1] := OUTSIDE;
   Moves := 1;
   For Y := 1 to 10 do
    With Exits[y] do begin
     Case X of
      1:ExitRoom := 2;
      2:ExitRoom := 1;
      3:ExitRoom := -1;
     End;
     If (Y = Up) and (X <> 3) then ExitRoom := -1;
     If (Y = Down) and (X = 1) then ExitRoom := -1;
     If (Y = Up) and (X = 3) then ExitRoom := 2;
     If (Y = Down) and (X = 2) then ExitRoom := 3;
     If (Y = SouthEast) and (X = 1) then Exitdoor := 2 else Exitdoor := 1;
     If (Y = NorthWest) and (X = 2) then Exitdoor := 2;
    end;
  end;
 D^[1].Name := 'doorway';
 D^[1].Desc := 'You see a doorway leading into a similar room.';
 D^[1].FlagWords := ' ';
 D^[1].Open := True;
 D^[1].Doorway := True;
 D^[1].KeyObj := -1;
 D^[2].Name := 'door';
 D^[2].Desc := 'You see a door.';
 D^[2].FlagWords := 'door';
 D^[2].Open := False;
 D^[2].Doorway := False;
 D^[2].KeyObj := 1;
 R[3].Name := '@MThe Dark Pit@M';
 R[3].Desc := 'This Dark Pit is thick with slime from some unknown monster, the pock marks@Mon the walls show old combats.@M';
 R[2].Name := '@MThe Adjacent Room@M';
 R[2].Desc := 'Dark lines marr the walls, a huge grand piano lies against the eastern wall,@Mand red blood is all over.@M';
 R[2].Exits[SouthEast].ExitRoom := -1;
 With O[1]^ do begin
  Name := 'The Default Object';
  Sdesc := 'Some foolish adventurer has left the default object, just LYING here!';
  Desc := 'Created by the god, Herb, this object is of pure obsidian, and holds a great@Mtrade value in local taverns.@M';
  Usage := 'You gaze at the objects'' luster and feel woozy.';
  flagwords := 'default object';
  physicals[1] := TREASURE;
  physicals[2] := TRASH;
  physicals[3] := ARMOR;
  physicals[4] := UNKNOWN;
  Ac := 0;
  Loc := Legs;
  effects[1] := GLOW;
  effects[2] := INVIS;
  effects[3] := SNEAK;
  effects[4] := NONE;
  types[1].settype := HITROLL;
  types[1].num1 := 15;
  types[2].settype := DAMROLL;
  types[2].num1 := 15;
  types[3].settype := STRENGTH;
  types[3].num1 := -1;
  types[4].settype := SEX;
  weight := 1;
 end;
 With O[2]^ do begin
  Name := 'Yet Another Object';
  SDesc := 'Guess what??  There is yet ANOTHER object here!';
  Desc := 'A large obelisk, it is blue and red with little blinky lights and a nice set@M'+
           'of blueish-green mists.  There is the word ''BOOP'' on it in red type.@M';
  FlagWords := 'another object';
  Usage := 'Donning the object, you feel less informed.';
  physicals[1] := ARMOR;
  Ac := -1;
  Loc := Wrists;
  For Y := 2 to 4 do Physicals[Y] := UNKNOWN;
  For Y := 1 to 4 do
   Begin
    Effects[Y] := NONE;
    Types[Y].Settype := NOTHING;
   End;
  Types[1].Settype := AGE;
  Types[1].Num1 := -12;
  Types[2].Settype := HITS;
  Types[2].Num1 := 20;
  Weight := 13;
 End;
 With M do begin
  Name := 'Beastly Rocko';
  Sdesc := 'You see the Beastly Rocko here.';
  Desc := 'Its slavering fingers and the slim line of thick drool which cascades down its@Mrough jowl turn you on sexually!@M';
  Flagwords := 'beastly rocko fido dog';
  AI := SCAVENGER;
  AI := WANDERER;
 end;
end;
   
Procedure Menu;
Var S,F,f2,OldCmd : String;
    i,l : integer;
    count : integer;
    show : boolean;
Begin
 L := 1;
 f := '';
 Repeat
  show := false;
  if f <> 'QUIT' then
   begin
    cwrite(R[l].Name);
    cwrite(R[l].Desc);
    for i := 1 to 16000 do if k^[i,1] = l then cwriteln(o[k^[i,2]]^.Sdesc);
   end;
  repeat
   Write('<',u.hp,'hp ',u.m,'m ',u.mv,'mv> ');
   ReadCmd(s);
   If Split(s,1) = '!' then S := OldCmd else OldCmd := S;
   f := upstring(split(s,1));
{   writeln('|'+f+'| #',countparams(s)); }
    if f = 'GET' then Begin
                       GetObj(U,L,Upstring(s));
                      End else
    if (f = 'EQ') or (f = 'EQUIPTMENT') then ShowWield(U) else
    if f = 'DROP' then Begin
                        DropObj(U,L,Upstring(s));
                       End else
    if dir(f) <> 0 then With D^[R[L].Exits[Dir(f)].ExitDoor] do
                        With R[L].Exits[Dir(f)] do
                        Begin
                         if not Open then cwriteln('The '+name+' is closed.');
                         if ExitRoom < 0 then cwriteln('Alas, you cannot go that way...');
                         if ((Open) or (Doorway)) and (ExitRoom > 0) then
                            begin
                             show := true;
                             u.Mv := u.Mv - r[l].Moves;
                             if u.mv < 0 then begin
                               cwriteln('You are too exhausted to move.');
                               u.mv := 0;
                              end else begin
                                L := ExitRoom;
                                inc(u.movetotal);
                               end;
                            end;
                        End else
    if f = 'OPEN' then Begin
                        f2 := upstring(split(s, 2));
                        if dir(f2) = 0 then cwriteln('Open WHAT? WHERE?') else
                         if D^[r[l].Exits[Dir(f2)].ExitDoor].Open then cwriteln('Its already open!') else
                         begin
                          D^[r[l].Exits[Dir(f2)].ExitDoor].Open := True;
                          cwriteln('You open the '+D^[r[l].exits[dir(f2)].ExitDoor].Name+'.');
                         end;
                       End else
    if f = 'CLOSE' then Begin
                        f2 := upstring(split(s, 2));
                        if dir(f2) = 0 then cwriteln('Close WHAT? WHERE?') else
                         if not D^[r[l].Exits[Dir(f2)].ExitDoor].Open then cwriteln('Its already closed!') else begin
                          D^[r[l].Exits[Dir(f2)].ExitDoor].Open := False;
                          cwriteln('You close the '+D^[r[l].exits[dir(f2)].ExitDoor].name+'.');
                         end;
                       End else
    if (f = 'SC') or (f = 'SCORE') then score(u) else
    if (F = 'I') or (f = 'INVENTORY') then Inventory(U) else
    if (f = 'QUIT') and (countparams(s) <> 1) then cwriteln('To quit, type QUIT with no parameters.') else
    if (f = 'QUIT') then else
    if (F = 'TIT') or (f = 'TITLE') then begin
                       i := 2;
                       u.sdesc := u.Charname;
                       if countparams(s) <> 1 then u.sdesc := u.sdesc + ' ';
                       repeat
                        u.sdesc := U.sdesc + split(s,i);
                        if i < countparams(s) then u.sdesc := u.sdesc + ' ';
                        inc(i);
                       until i > countparams(s);
                       Writeln('Title changed to: '''+u.sdesc+'''');
                      End else
    if (F = 'WEAR') then WearItem(U,S) else
    if (f = 'REM') or (f = 'REMOVE') then RemItem(U,S) else
    if (f = 'HELP') then ShowCommands(s) else
    if (f = 'L') or (f = 'LOOK') then begin
                                       f := upstring(split(s,2));
                                       if countparams(s) = 1 then show := true else
                                        if dir(f) <> 0 then begin
                                         if r[l].Exits[dir(f)].Exitroom = -1 then cwriteln('You see nothing special.') else
                                          cwriteln(D^[r[l].Exits[dir(f)].ExitDoor].Desc);
                                         end else
                                         if (f = 'AROUND') or (F = 'ROOM') then
                                          Begin
                                           cwrite(R[l].Name);
                                           cwrite(R[l].Desc);
                                           if (F = 'AROUND') then
                                            Begin
                                             Count := 0;
                                             For I := 1 to 16000 do if K^[I,1] = L then Inc(Count);
                                             Cwriteln('There are '+estimate(1,30,Count)+' items here.');
                                            End;
                                          End else lookobj(u,l,s);
                                      End else cwriteln('Argle bargle glop glyf?');
  until (upstring(split(s,1)) = 'QUIT') or (show);
 Until upstring(S) = 'QUIT';
 Showversion;
End;

Procedure DeAllocPtrs;
Var X : Integer;
Begin
 For X := 1 to 200 do Dispose(O[X]);
 Dispose(D);
 Dispose(K);
End;

Begin
 Randomize;
 ShowVersion;
 Pause;
 Writeln('ObjectType ',SizeOf(ObjectType));
 Writeln('UserType   ',SizeOf(UserType));
 Writeln('MobType    ',SizeOf(MobType));
 Writeln('ObjList    ',SizeOf(ObjList));
 Writeln('DoorList   ',SizeOf(DoorList));
 Writeln('RoomType   ',SizeOf(RoomType));
 Writeln('DoorType   ',SizeOf(DoorType));
 SetUpDefaults;
 Menu;
 DeAllocPtrs;
End.
