unit AnsiMenu;

interface

uses crt, doordriv;
type
 menutype = record
             header: string[80];
             footer: string[80];
             headercolor, footercolor, optioncolor, desccolor, arrowcolor: byte;
             bracketcolor: byte;
             numoptions: byte;
             options: array[1..20] of string[1];
             desc: array[1..20] of string[80];
            end;
const
 midscreeny: byte = 12;
 midscreenx: byte = 40;

function GetAnsiMenu(menu: menutype): char;

implementation

function centerstring(s: string): string;
var
 xpos: byte;
 a: integer;
begin;
 xpos:=midscreenx-(length(s) div 2);
 for a:=1 to xpos do s:=' '+s;
 CenterString:=s;
end;

procedure Cursor_Forward;
begin;
 if not local then sendtext(#27+'[C');
 gotoxy(wherex+1,wherey);
end;

function GetAnsiMenu(menu: menutype): char;
var
 menulength: byte;
 menutop: byte;
 menubottom: byte;
 optiontop: byte;
 optionbottom: byte;
 optionx: word;
 curpos, curoption, oldpos, oldoption: byte;
 a: byte;
 optionselect,ch: char;
 done: boolean;
begin;
 sclrscr;
 done:=false;
 menulength:=menu.NumOptions+4;
 menutop:=midscreeny-(menulength div 2);
 menubottom:=midscreeny+(menulength div 2);
 optiontop:=midscreeny-(menu.numoptions div 2);
 optionbottom:=midscreeny+(menu.numoptions div 2);
 if (menu.numoptions div 2) = (menu.numoptions / 2) then begin;
  optionbottom:=optionbottom-1;
  menubottom:=menubottom-1;
 end;
 optionx:=0;
 for a:=1 to menu.numoptions do optionx:=optionx+(length(menu.options[a])+length(menu.desc[a])+3);
 optionx:=midscreenx-(optionx div menu.numoptions) div 2;
 if color_chg then begin;
  set_foreground(menu.headercolor);
  sgoto_xy(1,menutop);
  swrite(centerstring(menu.header));
  for a:=1 to menu.numoptions do begin;
   sgoto_xy(optionx,optiontop+a-1);
   set_foreground(menu.bracketcolor);
   swrite('[');
   set_foreground(menu.optioncolor);
   swrite(menu.options[a]);
   set_foreground(menu.bracketcolor);
   swrite('] ');
   set_foreground(menu.desccolor);
   swrite(menu.desc[a]);
  end;
  set_foreground(menu.headercolor);
  sgoto_xy(1,menubottom);
  swrite(centerstring(menu.footer));
  curpos:=optiontop;
  curoption:=1;
  oldpos:=curpos;
  oldoption:=curoption;
  sgoto_xy(optionx,curpos);
  set_foreground(menu.arrowcolor);
  swrite('<');
  set_foreground(menu.optioncolor);
  swrite(menu.options[curoption]);
  set_foreground(menu.arrowcolor);
  swrite('>');
  repeat;
   sread_char(ch);
   if ((ch='8') or (ch=#30)) and (wherey>optiontop) then begin;
    curpos:=curpos-1;
    curoption:=curoption-1;
   end;
   if ((ch='2') or (ch=#31)) and (wherey<optionbottom) then begin;
    curpos:=curpos+1;
    curoption:=curoption+1;
   end;
   for a:=1 to menu.numoptions do if upcase(ch)=menu.options[a] then begin;
    curoption:=a;
    curpos:=optiontop+a-1;
    ch:=#13;
   end;
   sgoto_xy(optionx,oldpos);
   set_foreground(menu.bracketcolor);
   swrite('[');
   cursor_forward;
   swrite(']');
   sgoto_xy(optionx,curpos);
   set_foreground(menu.arrowcolor);
   swrite('<');
   cursor_forward;
   swrite('>');
   oldpos:=curpos;
   oldoption:=curoption;
   if ch=#13 then begin;
    optionselect:=menu.options[curoption][1];
    done:=true;
   end;
  until done;
  Getansimenu:=optionselect;
  set_foreground(default_fore);
 end else begin;
  while wherey<menutop do swriteln('');
  swriteln(centerstring(menu.header));
  swriteln('');
  for a:=1 to menu.numoptions do begin;
   while wherex<optionx do swrite(' ');
   swriteln('['+menu.options[a]+']'+' '+menu.desc[a]);
  end;
  swriteln('');
  swrite(centerstring(menu.footer));
  optionselect:=' ';
  repeat;
   sread_char(ch);
   ch:=upcase(ch);
   for a:=1 to menu.numoptions do if ch=menu.options[a] then optionselect:=ch;
  until optionselect<>' ';
  GetAnsiMenu:=optionselect;
 end;
end;

end.



