unit comio;
{$V-,S-,R-}

interface

uses fossilio, async;

procedure AsyncSelectPort(n: word);
procedure AsyncSendChar(ch: char);
procedure AsyncReceiveChar(var ch: char);
function AsyncCarrierPresent: boolean;
function AsyncCharPresent: boolean;
procedure AsyncSelectFossil;
procedure AsyncSelectInternal;
procedure AsyncCloseUp;
procedure AsyncSetBaud(n: word);
procedure AsyncSetDTR(state: boolean);
procedure AsyncFlushOutput;
procedure AsyncPurgeOutput;
procedure AsyncSendString(s: string);
procedure AsyncSetFlow(SoftTran,Hard,SoftRecv: boolean);
Procedure AsyncBufferStatus(var Insize,infree,outsize,outfree: word);

type
 AsyncIoTypes=(Fossil,Internal,Bios);
var
 AsyncIoType: AsyncIotypes;
 comport: word;
 initok: boolean;
 internalinsize,internaloutsize: word;

implementation

procedure AsyncSelectPort(n: word);
var
 b: boolean;
begin;
 comport:=n;
 case AsyncIoType of
  Fossil: begin;
           async_deinit_fossil;
           port_num:=n-1;
           initok:=async_init_fossil;
          end;
  Internal: begin;
             closeallcoms;
             initok:=opencom(n,InternalInSize,InternalOutSize);
            end;
 end;
end;

procedure AsyncSendChar(ch: char);
begin;
 case AsyncIoType of
  Fossil: async_send(ch);
  Internal: ComWriteChw(comport,ch);
 end;
end;

procedure AsyncReceiveChar(var ch: char);
var
 b: boolean;
begin;
 case asyncIotype of
  Fossil: b:=async_receive(ch);
  Internal: ch:=ComReadCh(comport);
 end;
end;

function AsyncCarrierPresent: boolean;
begin;
 case asyncIoType of
  Fossil: AsyncCarrierPresent:=async_carrier_present;
  Internal: AsyncCarrierPresent:=DCDStat(comport);
 end;
end;

function AsyncCharPresent: boolean;
begin;
 case asyncIoTYpe of
  Fossil: asyncCharPresent:=Async_buffer_check;
{  Internal: asynccharpresent:=(c_status[comport] and 1)=0;}
  Internal: asynccharpresent:=combufferleft(comport,'I')<>c_insize[comport];
 end;
end;

procedure AsyncSelectFossil;
begin;
 AsyncIoType:=Fossil;
end;

procedure AsyncCloseUp;
begin;
 case AsyncIoType of
  fossil: Async_deinit_fossil;
  internal: closeallcoms;
 end;
end;

procedure AsyncSetBaud(n: word);
begin;
 case asynciotype of
  fossil: async_set_baud(n);
  internal: comparams(comport,n,8,'N',1);
 end;
end;

procedure AsyncSelectInternal;
begin;
 AsyncIOType:=Internal;
end;

procedure AsyncSetDTR(state: boolean);
begin;
 case AsyncIOType of
  Fossil: async_set_dtr(state);
  Internal: SetDTR(comport,state);
 end;
end;

procedure AsyncFlushOutput;
begin;
 case AsyncIOType of
  Fossil: async_flush_output;
  Internal: ComWaitForClear(comport);
 end;
end;

procedure AsyncPurgeOutput;
begin;
 case AsyncIOType of
  Fossil: async_purge_output;
  Internal: ClearCom(comport,'O');
 end;
end;

procedure AsyncSendString(s: string);
var
 a: integer;
begin;
 for a:=1 to length(s) do AsyncSendChar(s[a]);
end;

procedure AsyncSetFlow(SoftTran,Hard,SoftRecv: boolean);
begin;
 case AsyncIOType of
  Fossil: async_set_flow(softtran,hard,softrecv);
  Internal: begin;
              SetCTSMode(comport,hard);
              SetRTSMode(comport,hard,65535,65535);
              SoftHandShake(comport,softtran,'A','A');
             end;
 end;
end;


Procedure AsyncBufferStatus(var Insize,infree,outsize,outfree: word);
begin;
 case asynciotype of
  fossil: async_buffer_Status(insize,infree,outsize,outfree);
  internal: begin;
             insize:=internalinsize;
             outsize:=internaloutsize;
             infree:=combufferleft(comport,'I');
             outfree:=combufferleft(comport,'O');
            end;
 end;
end;

begin;
 AsyncIoType:=Internal;
 comport:=1;
 internalinsize:=2048;
 internaloutsize:=256;
end.
