; SimpleDoOr Control File
;
; Like DoorDriver, the SimpleDoOr control file enables the sysop to configure
; certain aspects of the BBS.  The control file is broken into key aspects.
;
; 1 - each command (or configuration) is entered like this:
;
; COMMAND PARAMETERS
;
; Any like that begins with a semi-colon (;) is commented out and therefore
; ignored.  To remove a command simply place a semi-colon at the begining of
; the line.  Note: ONLY ONE COMMAND MAY BE ON A LINE
; Some commands like PORT and the flag commands (ones that have no parameters)
; are not required and may be commented out if they are not needed or if they
; would conflict with another command.
;
; 2 - configuration sections are made for easy access, reference and usage.
;
;
; Section 1 - BBS Configuration and Calibration:
;
;Command: BBSTYPE                Parameters: See Below
;
; The following BBS types (or software drop file types) are available:
;
;                     RBBS - Rbbs-Pc version 16.1+ (uses DORINFOx.DEF)
;                            (recommended use with TAG and RENEGADE BBS
;                            softwares)
;                    QUICK - Quickbbs; Uses DORINFOx.DEF (same as above)
;                    PCB12 - Pcboard version 12 (note: see COMPORT note below)
;                     WWIV - WWIV bbs (uses chain.txt)
;                  PHOENIX - Phoenix bbs
;                  WILDCAT - Wildcat bbs
;                    PCB14 - Pcboard version 14 (not fully tested)
;                  DOORSYS - The DOOR.SYS format (wildcat 3.0, TAG, etc)
;                 SPITFIRE - Spitfires drop file (SFDOORS.DAT)
;
; *NOTE* all BBS softwares are copyrighted to their respected owner
;
; To enter a BBS type, simply use the command BBSTYPE WWIV for WWIV, ect.
;
;Commands: COMPORT/PORT          Parameters: 1, 2, 3, 4
;
; Should the drop file of your BBS (namely PCBoard 12) have trouble detecting
; the correct com port, or the com port is not supplied in the drop file,
; the command PORT or COMPORT and a number for a parameter such that to force
; com port four to be active you could either use PORT 4 or COMPORT 4.
;
;Command: BBSNAME                Parameters: See Below
;
; The default by SimpleDoOr for this is "Some BBS", however to configure
; SimpleDoOr to your BBS's name, simply add this command and your BBS name
; as the Parameter, such that Infinity BBS would be BBSNAME Infinity BBS or
; BBSNAME Infinity.
;
;Commands: SYSOPFIRST/SYSOPLAST  Parameters: See Below
;
; To make sure that the sysop's first and last name are known by SimpleDoOr,
; you need only to add the parameters to these two commands.  If left blank,
; these commands will be defaulted to "Joe" and "Sysop".
;
;Command: PATH                   Parameters: Filespec
;
; This command supplies a path to the door drop files.  It is not required.
; If PATH is not declared in the control file, then it assumes the current
; directory.
;
;Command: INTERNAL               Parameters: None
;
; If you do not wish SimpleDoOr to make use of a fossil driver, simply add
; the command INTERNAL.  This is a flag command.
;
;Command: COLOR1                 Parameters: None
;
; If users who have ansi enabled do not see color, or ANSI codes are not
; being sent, the COLOR1 command must be entered.  The most frequent ANSI
; incompatability problems are under the RBBS DORINFOx.DEF file and compatible
; BBS drop files.  This is a flag command.
;
;Command: MAXTIME                Parameters: 1-255
;
; MAXTIME is an optional command that limits a user's time in the door
; per use.  The parameter is in minutes.  For two hours you would use the
; command:  MAXTIME 120

INTERNAL
SYSOPFIRST Joe
SYSOPLAST Sysop
BBSNAME Some BBS
BBSTYPE PCB14
;COLOR1
;MAXTIME 200
;PORT 1
;PATH C:\BBS\DOORS\DROPFILE\

;
; Section 2 - Display and Sound
;
; In the future, soundblaster support may or may not be added to SimpleDoOr.
; As of now, I have already assembled routines, however the logic of adding
; soundblaster support to an online program is in question.
;
;Command: QUIET                  Parameters: None
;
; Strips ALL control-G bell tones from the modem transfer of text.  This
; will cut down, but may not eliminate the PC speaker beeps.  This is a flag
; command.
;
;Command: 43LINE                 Parameters: None
;
; The display will be modified to 43/50 line EGA/VGA mode if this command is
; used.  This is a flag command.
;
;Command: STATUSLINE             Parameters: ON, OFF
;
; By using this command, the sysop may toggle ON or OFF the status line
; display.  This cuts down on screen updates and may speed up the program
; five to ten percent during text transfer.  To turn the status line off,
; the command would look like this:  STATUSLINE OFF
;
;Command: NODIRECT               Parameters: None
;
; Flagging this command on will turn off direct screen writes and use BIOS
; to display to the screen.  This is a flag command.
;
;Commands: STATFORE, STATBACK    Parameters: (1-7), (1-15)
;
; This is the sysop configurable color section for the status line.  The
; door may set the colors itself as a constant, but most likely the sysop
; will be able to modify the background color.  To change the foreground color
; to black, the command would look like this:  STATFORE 0
; Likewise, the background color would be set like this:  STATBACK 1
;
;Command: LOCALCOLOR             Parameters: None
;
; This flag command turns on local color.
;
;Command: MONOCHROME             Parameters: None
;
; This command turns on MONOCHROME color support.  It is a flag command.


STATUSLINE ON
QUIET
LOCALCOLOR
STATFORE 9
STATBACK 1
;43LINE
;MONOCHROME

