Var ATan : Array[0..628] of Real;
    Si : Array[0..628] of Real;
    Co : Array[0..628] of Real;

Procedure FindTables;
Var T : Integer;
Begin
 For T := 0 to 628 do Atan[T] := ArcTan(T/10);
 For T := 0 to 628 do Si[T] := Sin(T/10);
 For T := 0 to 628 do Co[T] := Cos(T/10);
End;

Procedure Rotate(OImage : ^ImagePtr; Var NImage : ^ImagePtr; SizeX, SizeY : Byte; Rads : Real);
Var X, Y, X1, Y1, HalfX, HalfY, A, B : Integer;
  Radius, ORads : Real;
Begin
  HalfX := SizeX Div 2;
  HalfY := SizeY Div 2;
  For X := 1 to SizeX do
    For Y := 1 to SizeY do
      Begin
        X1 := X - HalfX;
        Y1 := HalfY - Y;
        Radius := Sqrt( Sqr(X1) + Sqr(Y1) );
        If X1 > 0 Then
          ORads := ATan[Y1 Div X1]
        Else
          If X1 < 0 Then
            ORads := ATan[Y1 Div X1] + Pi
          Else
            ORads := ATan[0];
        ORads := ORads + Rads;
        A := Round( Radius * Co[Trunc(ORads*10)] ) + HalfX;
        B := -Round( Radius * Si[Trunc(ORads*10)] ) + HalfY;
        If (A in [1..SizeX]) and (B in [1..SizeY]) Then
          NImage.Map[X,Y] := OImage.Map[A,B]
        Else
          NImage.Map[X,Y] := 0;
      End;
End;
