#if 0
// C version works just fine but SLOW, kept it so you can tell
//   what the asm version does
/* ----------------- put_blit_packed() --------------------- March 23,1993 */
void put_blit_packed(char far *buffer, short x, short y, short width, short height)
{
   unsigned char num;
   char far *vid;
   unsigned short i;

   i=y*320 + x;
   vid=MK_FP(0xa000, i);
   i=320 - width;

   for ( y=0; y < height; y++ )
      {
      x=0;
      while ( x < width )
         {
         if ( *buffer )
            {
            buffer++;
            num=*buffer++;
            while ( num-- )
               {
               *vid++=*buffer++;
               x++;
               }
            }
         else
            {
            buffer++;
            num=*buffer++;
            vid+=num;
            x+=num;
            }
         }

      vid+=i;
      }


}
#endif

/*

   put a shape packed with pack shape
   run length encoded
   0 byte next byte is number of bytes to skip
   1 byte next byte is number of bytes to draw

   only useful for TRANSPARENT SHAPES

   MAX width and height is 255!!!!!

   all color zero areas will be transparent see pack.c for more

*/
void put_blit_packed(FARPTR buffer, short x, short y, short width, short height)
{

   asm   {
         push  ds
         push  di

         /* calc start address in video mem */
         mov   ax, y
         mov   bx, x
         xchg  ah, al
         add   bx, ax
         shr   ax, 1
         shr   ax, 1
         add   bx, ax

         /* set up address registers for movsw */
         mov   ax, 0xa000
         mov   es, ax
         mov   di, bx

         /* to make this draw to off-screen buffer add a dest parm
         FARPTR dest, and replace the above 3 lines with

         les   di, dest
         add,  di, bx

         see put_blit2() for an example

         */

         lds   si, buffer

         /* set up width and adjustment for fast blat */
         mov   dx, width
         mov   bx, 320
         sub   bx, width
         mov   ax, height
         xor   ch, ch
         }

         /* draw/skip each line */
l1:
   asm   {
         xor   dh, dh
         }
lm0:
   asm   {
         cmp   byte ptr [si], 1
         je    do_string

/*       skip black pixels */
         inc   si
         mov   cl, [si]
         add   di, cx
         add   dh, cl
         inc   si

         /* check if done one line */
         cmp   dh, dl
         jne   lm0

         /* done one line, move to next */
         add   di, bx
         dec   ax
         jnz   l1

         jmp   short the_end
         }

         /*    draw a string of pixels */
do_string:             
   asm   {
         inc   si

         mov   cl, [si]
         add   dh, cl
         inc   si

         rep   movsb

         /* check if done one line */
         cmp   dh, dl
         jne   lm0


         /* done one line, move to next */
         add   di, bx
         dec   ax
         jnz   l1
         }
the_end:
         /* all done */
   asm   {
         pop   di
         pop   ds
         }   
}


/*

   FAST and easy mode 13 clipping

   buffer - pointer to shape
   x, y   - where to put CLIPPED section of shape
   full_width - full width of shape
   dx, dy - where in shape to start blit
   width, height - of clipped section we are drawing


   shape

   |<-------- full_width----->|
   ----------------------------
   |   /\|                    |
   |   dy|                    |
   |   | |                    |
   |<dx->|<--width------>|    |
   |------------------------  |
   |     |               | /\ |
   |     |               | |  |
   |     |               | |  |
   |     |               | |  |
   |     |  this rect is | height
   |     |drawn at x, y  | |  |
   |     | on the screen | |  |
   |     |               | |  |
   |     |               | \/ |
   |     -------------------  |
   |                          |
   |                          |
   ----------------------------


*/
/* ---------------------- put_blit_clipped() ------------- April 24,1993 */
void put_blit_clipped(FARPTR buffer, short x, short y, short full_width,
                      short d_x, short d_y, short width, short height)
{
   unsigned short w;

   asm   {
         push  ds
         push  di

         /* calc w */
         mov   ax, full_width
         sub   ax, width
         mov   w, ax

         /* calc start adrress in buffer */
         lds   si, buffer
         mov   ax, full_width
         mul   word ptr d_y
         add   ax, d_x
         add   si, ax

         /* calc start address in vido mem */
         mov   ax, y
         mov   bx, x
         xchg  ah, al
         add   bx, ax
         shr   ax, 1
         shr   ax, 1
         add   bx, ax

         /* set up address registers for movsb */
         mov   ax, 0xa000
         mov   es, ax
         mov   di, bx

         /* set up width and adjustment for fast blat */
         mov   dx, width
         mov   bx, 320
         sub   bx, width
         mov   ax, height
         }

         /* blast each line */
l1:
   asm   {
         mov   cx, dx
         rep   movsb
         add   di, bx
         add   si, w
         dec   ax
         jnz   l1

         /* all done */
         pop   di
         pop   ds
         }   
}




/* ------------------------------ end of file ------------------------- */

; start of pack.c

/*

   copyright 1993, Alec Russell, all rights reserved

   stuff to pack shapes - a utility

*/



#include <mode13.h>


/*

   pack a shape to speed up drawing TRANSPARENT shapes

   run length encoded
   0 byte next byte is number of bytes to skip
   1 byte next byte is number of bytes to draw

   only useful for TRANSPARENT SHAPES

   all color zero areas will be transparent

   MAX width and height is 255!!!!!

   packed line by line for speed

   this is NOT a good way to pack stuff if interested in saving space

   Once packed, use put_blit_packed() to draw.
   Of course you will want to pack everthing in advance.
   I usually put the function below into a stand-alone util and
   pre-pack my sprites, saving them to disk packed.

*/
/* ---------------------- pack_shape() ------------------- April 15,1993 */
void pack_shape(shape_t *shp1, shape_t *shp2)
{
   char far *s0, far *s1, far *t;
   short num, x, y;

   s0=shp1->bitmap;
   s1=shp2->bitmap;

   for ( y=0; y < shp1->height; y++ )
      {
      x=0;
      while ( x < shp1->width )
         {
         if ( *s0 )
            {
            /* bytes isn't a zero so copy over until end of line or a zero */
            num=0;
            *s1++=1;
            t=s1;    /* save where the count goes */
            s1++;

            /* copy and count non-zero bytes */
            while ( *s0 && x < shp1->width )
               {
               num++;
               x++;
               *s1++=*s0++;
               }

            /* store count */
            *t=num;
            }
         else
            {
            /* count number of zeros to skip and store count */
            num=1;
            *s1++=0;
            s0++;
            x++;

            while ( *s0 == 0 && x < shp1->width )
               {
               num++;
               x++;
               s0++;
               }

            *s1++=num;
            }
         }
      }


}

/* -------------------------- end of file -------------------------- */
