#pragma inline


/*
   draws to the screen directly.

   x, y, width, height all in pixels, mode 0x13 ONLY

   MAX width and height is 255!!!!!

   buffer pointer to a width by height array of bytes that are a bitmap

   x, y is position to display at, NO checking done for valid
   co-ords etc...

   WIDTH MUST BE EVEN!!!!


*/
/* ---------------------- put_blit() --------------------- March 23,1993 */
void put_blit(FARPTR buffer, short x, short y, short width, short height)
{
   asm   {
         push  ds
         push  di

         /* calc start address in vido mem */
         mov   ax, y
         mov   bx, x
         xchg  ah, al
         add   bx, ax
         shr   ax, 1
         shr   ax, 1
         add   bx, ax

         /* set up address registers for movsw */
         mov   ax, 0xa000
         mov   es, ax
         mov   di, bx
         lds   si, buffer

         /* set up width and adjustment for fast blat */
         mov   dx, width
         shr   dx, 1
         mov   bx, 320
         sub   bx, width
         mov   ax, height
         }

         /* blast each line */
l1:
   asm   {
         mov   cx, dx
         rep   movsw
         add   di, bx
         dec   ax
         jnz   l1

         /* all done */
         pop   di
         pop   ds
         }   
}



/*
   draws to any buffer that is 320x200 in size

   x, y, width, height all in pixels, mode 0x13 ONLY

   MAX width and height is 255!!!!!

   buffer pointer to a width by height array of bytes that are a bitmap

   x, y is position to display at, NO checking done for valid
   co-ords etc...

   WIDTH MUST BE EVEN!!!!

*/
/* ---------------------- put_blit2() --------------------- March 23,1993 */
void put_blit2(FARPTR buffer, short x, short y,
              short width, short height,
              FARPTR dest)
{
   asm   {
         push  ds
         push  di

         /* calc start address in vido mem */
         mov   ax, y
         mov   bx, x
         xchg  ah, al
         add   bx, ax
         shr   ax, 1
         shr   ax, 1
         add   bx, ax

         /* set up address registers for movsw */
         les   di, dest  // es:di points to start dest
         add   di, bx    // make es:di point to x,y in dest

         lds   si, buffer

         /* set up width and adjustment for fast blat */
         mov   dx, width
         shr   dx, 1
         mov   bx, 320
         sub   bx, width
         mov   ax, height
         }

         /* blast each line */
l1:
   asm   {
         mov   cx, dx
         rep   movsw
         add   di, bx
         dec   ax
         jnz   l1

         /* all done */
         pop   di
         pop   ds
         }   
}
