/*
    key.c
    Internet: alexad3@icebox.iceonline.com
    Copyright 1995, May 14 by Alec Russell, ALL rights reserved
    Permission granted to use ths code as you wish.

    Created - 1995/5/14

    History:
        New file

   An example of a reading raw scan codes

*/
#include <stdio.h>
#include <dos.h>

#define BYTE unsigned char
#define NUM_SCAN_QUE 256     // this MUST be 256, using BYTE roll-over for
                             // q code

static void interrupt (far *oldkb)();   /* BIOS keyboard handler */

// Q code
BYTE gb_scan;
BYTE gb_scan_q[NUM_SCAN_QUE];
BYTE gb_scan_head;
BYTE gb_scan_tail;


/*

   invoked by the hardware keyboard interupt


   ques up the raw scan codes

   updated March 1995, to handle 0e0h better


   stuff raw scan codes into the array gb_scan_q[]
*/
/* ---------------------- get_scan() --------------------- April 17,1993 */
void interrupt get_scan(void)
{

   /* read the raw scan code from the keyboard */
   asm   cli

read1:
   asm   {

         in    al, 060h       /* read scan code */
         cmp   al, 0e0h       /* its the second keypad */
         jne    read2

         /* 0e0h indicates the second cursor pad, reset and try again */
         in    al, 061h       /* read keyboard status */
         mov   bl, al
         or    al, 080h
         out   061h, al       /* set bit 7 and write */
         mov   al, bl
         out   061h, al       /* write agian, bit 7 clear */

         mov   al, 020h       /* reset PIC */
         out   020h, al

         jmp short read1
         }

read2:
   asm   {
         mov   gb_scan, al

         /* this code re-sets the keyboard, and pic to get ready
            for next key-press
         */
         in    al, 061h       /* read keyboard status */
         mov   bl, al
         or    al, 080h
         out   061h, al       /* set bit 7 and write */
         mov   al, bl
         out   061h, al       /* write agian, bit 7 clear */

         mov   al, 020h       /* reset PIC */
         out   020h, al

         /* end of re-set code */

         sti
         }

   *(gb_scan_q+gb_scan_tail)=gb_scan;
   ++gb_scan_tail;

   /*

   If you just want to look for certain keys for some special
   action, but want the keyboard to otherwise behave normally
   don't call the re-set code, and DO call the old keyboard handler

   simply like this:


   oldkb();

   If you don't call oldkb() you MUST have that re-set code in there
   or your computer will hang or crash.

   Now that you have the raw scan code it is up to you to convert
   it to ASCII or do whatever you want.

   */
}

/* ---------------------- init_keyboard() ---------------- April 17,1993 */
void init_keyboard(void)
{
   BYTE far *bios_key_state;

   /* save old BIOS key board handler */
   oldkb=getvect(9);

   // turn off num-lock via BIOS 
   bios_key_state=MK_FP(0x040, 0x017);
   *bios_key_state&=(~(32 | 64));     // toggle off caps lock and
                                      // num lock bits in the BIOS varible
   oldkb();      // call BIOS keyhandler to change keyboard lights

   gb_scan_head=0;
   gb_scan_tail=0;
   gb_scan=0;

   /* setup our own handler */
   setvect(9, get_scan);

}

/* restore the bios keyboard handler */
/* ---------------------- deinit_keyboard() -------------- April 17,1993 */
void deinit_keyboard(void)
{
   setvect(9, oldkb);
}


/* ---------------------- main() ------------------------ October 7,1995 */
void main(void)
{
   int key;

   init_keyboard();

   printf("Press ESC to quit\n");
   key=999;
   do
      {
      while ( gb_scan_head != gb_scan_tail )
         {
         key=*(gb_scan_q+gb_scan_head);
         ++gb_scan_head;
         
         printf("%03d %03x\n", key, key);
         }

      }
   while ( key != 1 );

   deinit_keyboard();
}



/* ------------------------------ EOF -------------------------------- */
