/*

    m13.c

    Internet: alexad3@icebox.iceonline.com
    Copyright 1995, May 10 by Alec Russell, ALL rights reserved

    Created - 1995/5/10

    History:
        New file

*/


/*

   damn fast, bitmap drawing routine

   x, y, width, height all in pixels, mode 0x13 ONLY

   MAX width and height is 255!!!!!

   buffer pointer to a width by height array of bytes that are a bitmap

   x, y is position to display at, NO checking done for valid
   co-ords etc...

   WIDTH MUST BE EVEN!!!!

*/
/* ---------------------- put_blit() --------------------- March 23,1993 */
void put_blit(FARPTR buffer, short x, short y, short width, short height)
{
   asm   {
         push  ds
         push  di

         /* calc start address in vido mem */
         mov   ax, y
         mov   bx, x
         xchg  ah, al
         add   bx, ax
         shr   ax, 1
         shr   ax, 1
         add   bx, ax

         /* set up address registers for movsw */
         mov   ax, 0xa000
         mov   es, ax
         mov   di, bx
         lds   si, buffer

         /* set up width and adjustment for fast blat */
         mov   dx, width
         shr   dx, 1
         mov   bx, 320
         sub   bx, width
         mov   ax, height
         }

         /* blast each line */
l1:
   asm   {
         mov   cx, dx
         rep   movsw
         add   di, bx
         dec   ax
         jnz   l1

         /* all done */
         pop   di
         pop   ds
         }   
}


/* ---------------------- put_blit() --------------------- March 23,1993 */
void put_blit_odd(FARPTR buffer, short x, short y, short width, short height)
{
   asm   {
         push  ds
         push  di

         /* calc start address in vido mem */
         mov   ax, y
         mov   bx, x
         xchg  ah, al
         add   bx, ax
         shr   ax, 1
         shr   ax, 1
         add   bx, ax

         /* set up address registers for movsw */
         mov   ax, 0xa000
         mov   es, ax
         mov   di, bx
         lds   si, buffer

         /* set up width and adjustment for fast blat */
         mov   dx, width
         shr   dx, 1
         mov   bx, 320
         sub   bx, width
         mov   ax, height
         }

         /* blast each line */
l1:
   asm   {
         mov   cx, dx
         rep   movsw
	      adc   cx,0        /* this trick is the fastest for 386, but a cmp/brn
                              might be faster on the 486 & p5 */ 
	      rep   movsb
         add   di, bx
         dec   ax
         jnz   l1

         /* all done */
         pop   di
         pop   ds
         }   
}

/* ------------------------------ EOF -------------------------------- */

