/*

Copyright 1995 Alec Russell, ALL rights reserved.
Permission granted by Alec Russell to use this code as anyone wishes.

*/

#define INPUT_STATUS_1  03dah   //Input Status 1 register
#define INPUT_STATUS_0  03dah   //Input status 0 register


/* set the VGA palette, p points to valid palette of 768 bytes
   of rgb triples

   works in all xmodes too - faster than the one in xlib
*/
void setvgapalette(char *p)
{

   /* wait for vert sync */
   asm   {
         mov     dx,INPUT_STATUS_1
         }
WaitVS:
   asm   {
         in      al,dx
         test    al,08h
         jz      WaitVS  /* vertical sync is active high (1 = active) */
         }

   asm   {
         .386

/*       this sets the default palette register mask, don't need to do
         this unless it gets changed

         mov   dx, 03c6h
         mov   al, 0ffh
         out   dx, al
*/

         /* set palette, taking advantage of the auto-increment feature */
         xor   al, al
         mov   dx, 03c8h
         out   dx, al
         mov   cx, 768
         mov   si, p
         mov   dx, 03c9h
         rep   outsb
         }
}



/* ---------------------- setvga_part_palette() ---------- March 28,1993 */
void setvga_part_palette(char *p, short start, short num)
{

   p+=start*3;
   num*=3;

   /* wait for vert sync */
   asm   {
         mov     dx,INPUT_STATUS_1
         }
WaitVS:
   asm   {
         in      al,dx
         test    al,08h
         jz      WaitVS  /* vertical sync is active high (1 = active) */
         }

   asm   {
         .386

         /* set partial palette */
         mov   ax, start
         mov   dx, 03c8h
         out   dx, al
         mov   cx, num
         mov   si, p
         mov   dx, 03c9h
         rep   outsb
         }
}



/* do colour cycling, starting with color start, num sequential colors */
/* ---------------------- cycle_palette() ---------------- March 28,1993 */
void cycle_palette(short start, short num)
{
   BYTE t[3];
   short x1, x2, len;

   num--;
   len=num*3;


   x1=start*3;
   x2=len + x1;

   /* cycle the palette  */
   memcpy(t, palette+x1, 3);
   memmove(palette+x1, palette+x1+3, len);
   memcpy(palette+x2, t, 3);

   /* set new pallette */
   num++;
   setvga_part_palette(palette, start, num);
}
